<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Models\Order_history;
use Carbon\Carbon;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $users = User::all();
        $employee = User::where('role', 'Employee')->get();

        if($request->search){

            $orders = Order::orderBy('id','DESC')->paginate(10);

        } else
        {
            $orders = Order::orderBy('id','DESC')->paginate(10);
        }

        return view('order.index',compact('orders','request','users','employee'));
    }

    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::all();
        $employee = User::where('role', 'Employee')->get();

        $ordersQuery = Order::orderBy('id', 'desc')
        ->with(['user', 'customer']);

    if ($request->user_id) {
        $ordersQuery->where('user_id', $request->user_id);
    }

    if ($request->employee_id) {
        $ordersQuery->where('user_id', $request->employee_id);
    }

    $orders = $ordersQuery->paginate(10);

    return view('order.index', compact('orders', 'users', 'request', 'employee'));
}


    public function View_details( $id)
    {
        $id = decrypt($id);
        $orders = Order::with('user')->find($id);
        $order_histories = Order_history::where('order_id', $id)->get();
        return view('order.view_details',compact('orders','order_histories'));
    }

    public function delete($id)
    {
        $id=decrypt($id);

        $orders = Order::find($id);

        $orders->delete();

        return redirect('orders')->with('error','Complain deleted successfully.');
    }
}
