<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\InfoAlert;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;

class InfoAlertController extends Controller
{
    public function index(Request $request){

        if($request->search){

            $searchDate = Carbon::createFromFormat('d-m-Y', $request->search)->format('Y-m-d');

            $info_alerts = infoalert::orderBy('id','DESC')
                ->whereDate('created_at', $searchDate)
                ->paginate(10);

        } else
        {
            $info_alerts = infoalert::orderBy('id','DESC')->paginate(10);
        }

        return view('infoalert.index',compact('info_alerts','request'));
    }


    public function create()
    {
        return view('infoalert.create');
    }

    public function store(Request $request)
    {

        $this->validate($request,[
            'message' => 'required',
        ]);

            $data['message'] = $request->message;

            $info_alerts = InfoAlert::create($data);

            if ($info_alerts ) {
                return redirect('info_alerts')->with('success', 'info_alerts created successfully.');
            } else {
                return redirect('info_alerts')->with('error', 'Something went wrong.');
            }
    }

    public function date(Request $request)
    {
        $info_alerts = infoalert::orderBy('id', 'desc')
            ->when(
                $request->date_from && $request->date_to,
                function (Builder $builder) use ($request) {
                    $builder->whereBetween(
                        DB::raw('DATE(created_at)'),
                        [
                            $request->date_from,
                            $request->date_to
                        ]
                    );
                }
            )->paginate(10);

        return view('infoalert.index', compact('info_alerts','request'));
    }

    public function edit($id)
    {
        $id=decrypt($id);

        $info_alerts = InfoAlert::find($id);

        return view('infoalert.edit',compact('info_alerts'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'message' => 'required',
        ]);

        $info_alerts= InfoAlert::find($id);

        $data = [

            'message' => $request->message,
        ];

        $info_alerts->update($data);

        return redirect('info_alerts')->with('success', 'info_alerts updated successfully.');
    }


    public function delete($id)
    {
        $id=decrypt($id);

        $info_alerts=InfoAlert::find($id);

        $info_alerts->delete();

        return redirect('info_alerts')->with('error','info_alerts deleted successfully.');
    }
}
