<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CategoryMaster;

class CategoryMasterController extends Controller
{

    public function index(Request $request){

        if($request->search){

            $category_masters = CategoryMaster::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $category_masters = CategoryMaster::orderBy('id','DESC')->paginate(10);
        }

        return view('categorymaster.index',compact('category_masters','request'));
    }

    public function create()
    {

        return view('categorymaster.create');

    }
    public function store(Request $request)
    {

        $this->validate($request,[
            'name' => 'required',
            'image' => 'required',
        ]);

        if($request->hasFile('image'))
        {
            $imageName = time().'.'.$request->image->extension();

            $path = $request->image->move(public_path('/uploads/category/'), $imageName);

            $data['image'] = $imageName;
        }
            $data['name'] = $request->name;

            $category = CategoryMaster::create($data);

            if ($category ) {
                return redirect('category')->with('success', 'Brand Master created successfully.');
            } else {
                return redirect('category')->with('error', 'Something went wrong.');
            }
        }

            public function edit($id)
        {
            $id=decrypt($id);

            $category = CategoryMaster::find($id);

            return view('categorymaster.edit',compact('category'));
        }

            public function update(Request $request, $id)
            {
                $this->validate($request,[
                    'name' => 'required',
                ]);

                $category= CategoryMaster::find($id);

                $data = [

                    'name' => $request->name,
                ];

            if ($request->hasFile('image'))
            {
                $imageName = time() . '.' . $request->image->extension();

                $path = $request->image->move(public_path('/uploads/category/'), $imageName);

                $data['image'] = $imageName;
            }

                $category->update($data);

                return redirect('category')->with('success', 'Brand Master  updated successfully.');
            }


            public function delete($id)
            {
                $id=decrypt($id);

                $category = CategoryMaster::find($id);

                $category->delete();

                return redirect('category')->with('error','Brand Master deleted successfully.');
            }
}
