<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BrandMaster;

class BrandMasterController extends Controller
{

    public function index(Request $request){

        if($request->search){

            $brand_masters = BrandMaster::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $brand_masters = BrandMaster::orderBy('id','DESC')->paginate(10);
        }

        return view('brandmaster.index',compact('brand_masters','request'));
    }

    public function create()
    {

        return view('brandmaster.create');

    }
    public function store(Request $request)
    {

        $this->validate($request,[
            'name' => 'required',
            'image' => 'required',
        ]);

        if($request->hasFile('image'))
        {
            $imageName = time().'.'.$request->image->extension();

            $path = $request->image->move(public_path('/uploads/brands/'), $imageName);

            $data['image'] = $imageName;
        }
            $data['name'] = $request->name;

            $brands = BrandMaster::create($data);

            if ($brands ) {
                return redirect('brandmaster')->with('success', 'Brand Master created successfully.');
            } else {
                return redirect('brandmaster')->with('error', 'Something went wrong.');
            }
        }

            public function edit($id)
        {
            $id=decrypt($id);

            $brand_masters = BrandMaster::find($id);

            return view('brandmaster.edit',compact('brand_masters'));
        }

            public function update(Request $request, $id)
            {
                $this->validate($request,[
                    'name' => 'required',
                ]);

                $brands= BrandMaster::find($id);

                $data = [

                    'name' => $request->name,
                ];


            if ($request->hasFile('image'))
            {
                $imageName = time() . '.' . $request->image->extension();

                $path = $request->image->move(public_path('/uploads/brands/'), $imageName);

                $data['image'] = $imageName;
            }

                $brands->update($data);

                return redirect('brandmaster')->with('success', 'Brand Master  updated successfully.');
            }


            public function delete($id)
            {
                $id=decrypt($id);

                $brands=BrandMaster::find($id);

                $brands->delete();

                return redirect('brandmaster')->with('error','Brand Master deleted successfully.');
            }
}
