<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Attendance;
use App\Models\User;
use Carbon\Carbon;

class AttendenceController extends Controller
{
    public function index(Request $request)
    {

        $users = User::where('role', 'Agent')->get();

        if($request->search){

            $searchDate = Carbon::createFromFormat('d-m-Y', $request->search)->format('Y-m-d');

            $attendences = Attendance::orderBy('id','DESC')
                ->whereDate('date', $searchDate)
                ->paginate(10);

        } else
        {
            $attendences = Attendance::orderBy('id','DESC')->paginate(10);
        }

        return view('attendence.index',compact('attendences','request','users'));
    }



    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::where('role', 'Agent')->get();

        $attendences = Attendance::orderBy('id', 'desc')
            ->with('user')
            ->when($request->employee_id, function ($query) use ($request) {
                $query->where('usr_id', $request->employee_id);
            })
            ->paginate(10);

        return view('attendence.index', compact('attendences', 'users', 'request'));
    }

    

    public function delete($id)
    {
        $id=decrypt($id);

        $attendence = Attendance::find($id);

        $attendence->delete();

        return redirect('attendence')->with('error','Attendance deleted successfully.');
    }
}
