<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\{Company,Currency,AllCurrency,Source,Group,GroupUsers,ServiceInvoice,Service_Invoice_History,AddProduct,Suggestion,Order,Complain};
use Hash;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Rules\MobileNumberValidation;
use Illuminate\Support\Facades\Crypt;
class AdminController extends Controller
{
    public function index(Request $request)
    {
        $id=$request->id;
        $inv_details=ServiceInvoice::find($id);
        $inv_history=Service_Invoice_History::where('inv_id',$id)->get();
        $companylogo=Session::get('data');
        return view('frontend.components-invoice',compact('inv_details','companylogo','inv_history'));

    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {


    }

    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        //
    }


    public function update($id,Request $request)
    {
         if($request->logo)
        {
            if($request->file('logo')){
                $file= $request->file('logo');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }

            Company::where('id',$id)->
            update([
                'name'=>$request->name,
                'city'=>$request->city,
                'state'=>$request->state,
                'country'=>$request->country,
                'address'=>$request->address,
                'GST'=>$request->GST,
                'logo'=>$filename,
            ]);
            return redirect()->route('users-profile')->with('success','Company Profile Update Successfully');

        }
          Company::where('id',$id)->
          update([
            'name'=>$request->name,
            'city'=>$request->city,
            'state'=>$request->state,
            'country'=>$request->country,
            'address'=>$request->address,
            'GST'=>$request->GST,
          ]);

         return redirect()->route('users-profile')->with('success','Company Profile Update Successfully');
    }


    public function destroy($id)
    {
       //
    }
    public function signIn(Request $request)
    {
        $email=$request->email;
        $password=$request->password;
        if (Auth::attempt(['email'=>$email,'password'=>$password]))
        {
            return redirect('/index');
        }
        else
        {
            return redirect('/')->with('success','something went wrong..');
        }
    }

    public function Dashboard(Request $request)
    {
      $companies=Company::get()->first();
      $add_products = AddProduct::orderBy('id','DESC')->paginate(10);
      $suggestions = Suggestion::orderBy('id','DESC')->paginate(10);
      $orders = Order::orderBy('id','DESC')->paginate(10);
      $users = User::whereHas('roles', function ($query) {
      $query->where('name', 'Customer');})->orderBy('id', 'desc')->paginate(10);
      $complains = Complain::orderBy('id','DESC')->paginate(10);
      $logo=$companies->logo;
      Session::put('logo',$logo);
      return view('frontend.index',compact('add_products','suggestions','orders','users','complains'));

     }

   public function Currencyfun(Request $request)
   {
     $var=Currency::get()->first();
     $symb=AllCurrency::where('id',$var->currency_id)->first();
     $allcurr=AllCurrency::all();
     return view('frontend.currency-pages',compact('symb','allcurr'));
   }

   public function SetCurrency(Request $request)
   {
    $curr=Currency::get()->first();
    if($curr){
         Currency::where('id',$curr->id)->
         update([
        'currency_id'=>$request->currency,
         ]);
     }
     else{

         $params['currency_id']=$request->currency;
         Currency::create($params);

     }
     $var=Currency::get()->first();
     $symb=AllCurrency::where('id',$var->currency_id)->first();
     $allcurr=AllCurrency::all();
     return view('frontend.currency-pages',compact('symb','allcurr'));

   }

   public function AddCurrency(Request $request)
   {
    $params['cur_name']=$request->cur_name;
    $params['csymbol']=$request->csymbol;
    $params['country']=$request->country;
    $params['cur_code']=$request->cur_code;
    AllCurrency::create($params);
    $var=Currency::get()->first();
    $symb=AllCurrency::where('id',$var->currency_id)->first();
    $allcurr=AllCurrency::all();
    return view('frontend.currency-pages',compact('symb','allcurr'));
   }

   public function deleteCurrency($id)
   {
    $cur=AllCurrency::where('id',$id)->first();
    $cur->delete();
    $var=Currency::get()->first();
    $symb=AllCurrency::where('id',$var->currency_id)->first();
    $allcurr=AllCurrency::all();
    return view('frontend.currency-pages',compact('symb','allcurr'));
   }


   public function LeadSource(Request $request)
   {
    $source=Source::where('company_id',Auth::user()->company_id)->orderby('id','desc')->get();
    return view('frontend.lead-source',compact('source'));
   }

   public function SaveSource(Request $request)
   {
    $comp_id=Auth::user()->company_id;
    $params['company_id']=$comp_id;
    $params['name']=$request->name;
    Source::create($params);
    return redirect('/leadsource');
   }

   public function EditSource($id,Request $request)
   {
    $comp_id=Auth::user()->company_id;
    Source::where('id',$id)->
    update([
        'name'=>$request->name,
    ]);
    return redirect('/leadsource');
   }

   public function DeleteSource($id)
   {
    $data=Source::find($id);
    $data->delete();
    return redirect('/leadsource');
   }

   public function SourceStatus(Request $request)
   {
    $id=$request->source_id;
    Source::find($id)
            ->update([
                'status'=>$request->status,
            ]);
    return response()->json(['success'=>'Status change successfully.']);
   }



   public function UserProfile()
   {
     $companies=Company::get()->first();
      $logo=$companies->logo;
      Session::put('logo',$logo);
     return view('frontend.users-profile',compact('companies'));
   }


//    public function Search(Request $request)
//    {
//     $companyusers=User::where('company_id',Auth::user()->company_id)->get();
//     $leads=Lead::where('phone',$request->searchquery)->get();
//     if(count($leads)!=0){
//      return view('frontend.searchpage',compact('leads','companyusers'));
//     }
//     else{
//         $leads=0;
//         return view('frontend.searchpage',compact('leads','companyusers'));
//     }

//    }
}





