<?php

namespace App\Http\Controllers;

use App\Models\{AddProduct,CategoryMaster};
use Illuminate\Http\Request;

class AddProductController extends Controller
{
    public function index(Request $request)
    {

        if($request->search){
            $add_products = AddProduct::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);
        } else
        {
            $add_products = AddProduct::orderBy('id','DESC')->paginate(10);
        }
        return view('product.index',compact('add_products','request'));

    }

    public function create()
    {
        $category=CategoryMaster::all();

        return view('product.create',compact('category'));
    }

    public function store(Request $request)
    {
        

        if ($request->hasFile('image'))
        {
            $imageName = time() . '.' . $request->image->extension();

            $path = $request->image->move(public_path('/uploads/product/'), $imageName);

            $data['image'] = $imageName;
        }

        if ($request->hasFile('offer_image'))
        {
            $imageName = time() . '.' . $request->offer_image->extension();

            $path = $request->offer_image->move(public_path('/uploads/product/'), $imageName);

            $data['offer_image'] = $imageName;
        }


            $data['name'] = $request->name;
            $data['category']=$request->category;
            $data['unit'] = $request->unit;
            $data['product_price'] = $request->product_price;
            $data['GST'] = $request->GST;
            $data['stock_qty'] = $request->stock_qty;
            $data['agent_commission'] = $request->agent_commission;
            $data['offer_title'] = $request->offer_title;
            $data['description'] = $request->description;
            $data['product_features'] = $request->product_features;

            $product = AddProduct::create($data);

            if ($product ) {
                return redirect('products')->with('success', 'Add Product created successfully.');
            } else {
                return redirect('products')->with('error', 'Something went wrong.');
            }
    }

    public function edit($id)
    {
        $id=decrypt($id);
       
        $product = AddProduct::find($id);

        $category=CategoryMaster::all();

        return view('product.edit',compact('product','category'));
    }

    public function update(Request $request, $id)

    {
            
            $product= AddProduct::find($id);

            $data = [
                'name' => $request->name,
                'unit' => $request->unit,
                'stock_qty' => $request->stock_qty,
                'category' =>$request->category,
                'pruduct_price' => $request->product_price,
                'GST' => $request->GST,
                'agent_commission' => $request->agent_commission,
                'offer_title' => $request->offer_title,
                'description' => $request->description,
                'product_features' => $request->product_features
            ];

            if ($request->hasFile('image'))
            {
                $imageName = time() . '.' . $request->image->extension();

                $path = $request->image->move(public_path('/uploads/product/'), $imageName);

                $data['image'] = $imageName;
            }

            if ($request->hasFile('offer_image'))
            {
                $imageName = time() . '.' . $request->offer_image->extension();

                $path = $request->offer_image->move(public_path('/uploads/product/'), $imageName);

                $data['offer_image'] = $imageName;
            }



            $product->update($data);

            return redirect('products')->with('success', 'Product updated successfully.');
        }


        public function delete($id)
        {
            $id=decrypt($id);

            $product=AddProduct::find($id);

            $product->delete();

            return redirect('products')->with('error','Product deleted successfully.');
        }


        public function product_Active($id){
            $data=AddProduct::find($id);
            if($data->status=='1'){
                $status='0';
            }else{
                $status='1';
            }
            $data->update([
                'status'=>$status
            ]);
            return back()->with('success', 'Category status Update successfully.');

        }


}
