<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use App\Models\{AddProduct, Attendance, BrandMaster, CategoryMaster, User,Complain,Order, Order_history,Slider,Report,Suggestion,InfoAlert,Leave};
use DateTime;
use DatePeriod;
use DateInterval;

class ApiController extends Controller
{
                public function login(Request $request)
                {
                    $this->validate($request,[
                        'password' => 'required',
                        'email' => 'required'
                    ]);

                    $email = $request->input('email');
                    $password = $request->input('password');

                    $user = User::where('email', $email)->first();

                    if (!$user || !Hash::check($password, $user->password)) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'Invalid email or password!',
                        ], 200);
                    }

                    if ($user->status == 0) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'Your account is deactivated. Please contact the admin for reactivation.',
                        ], 200);
                    }

                    return response()->json([
                        'status' => 'true',
                        'msg' => 'User logged in successfully!',
                        'data' => $user
                    ], 200);
                }


                public function userShow()
                {
                    $users = User::where('status', 1)->get();

                    if (!$users->isEmpty()) {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All active users',
                            'data' => $users
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No active users found',
                        ], 200);
                    }
                }


                public function CustomerShow()
                {
                    $users = User::where('role', 'Customer')->where('status', 1)->get();

                    if ($users->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'Customer Data Not Found',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'Customer Data Found',
                            'data' => $users,
                        ], 200);
                    }
                }

                public function userShowid(Request $request)
                {
                    $this->validate($request, [
                        'user_id' => 'required'
                    ]);

                    $user_id = $request->input('user_id');
                    $user = User::find($user_id);

                    if (!$user) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'User not found',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'data' => $user
                        ], 200);
                    }
                }



                public function productShow()
                {
                    $products = AddProduct::with('Group')->where('status', 1)->get();

                    if ($products->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'Products not found.',
                        ], 200);
                    } else {
                        $formattedProducts = $products->map(function ($product) {
                            return [
                                'id' => $product->id,
                                'name' => $product->name,
                                'unit' => $product->unit,
                                'group' => $product->Group->name,
                                'image' => $product->image,
                                'hsn_code' => $product->hsn_code,
                                'stock_qty' => $product->stock_qty,
                                'sale_price' => $product->sale_price,
                                'opening_stock' => $product->opening_stock,
                                'part_no' => $product->part_no,
                                'status' => $product->status,
                                'created_at' => $product->created_at,
                                'updated_at' => $product->updated_at,
                            ];
                        });

                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All products retrieved successfully.',
                            'data' => $formattedProducts,
                        ], 200);
                    }
                }


                public function productShowid(Request $request)
                {
                    $this->validate($request, [
                        'product_id' => 'required'
                    ]);

                    $product_id = $request->input('product_id');
                    $product = AddProduct::with('Group')->find($product_id);

                    if (!$product) {
                        return response()->json(['status' => 'false','msg' => 'Product Not found',
                        ], 200);
                    } else {
                        // Manipulate the data before returning
                        $formattedData = [
                            'id' => $product->id,
                                'name' => $product->name,
                                'unit' => $product->unit,
                                'group' => $product->Group->name,
                                'image' => $product->image,
                                'hsn_code' => $product->hsn_code,
                                'status' => $product->status,
                                'stock_qty' => $product->stock_qty,
                                'sale_price' => $product->sale_price,
                                'opening_stock' => $product->opening_stock,
                                'part_no' => $product->part_no,
                                'created_at' => $product->created_at,
                                'updated_at' => $product->updated_at,
                        ];

                        return response()->json(['status' => 'true','data' => $formattedData,
                        ], 200);
                    }
                }


                public function product_by_group(Request $request)
                {
                    $this->validate($request, [
                        'group_id' => 'required'
                    ]);

                    $group_id = $request->input('group_id');

                    $products = AddProduct::with('Group')->where('group', $group_id)->get();

                    if ($products->isEmpty()) {
                        return response()->json(['status' => 'false','msg' => 'No products found for the given group ID.',
                        ], 200);
                    } else {
                        // Manipulate the data before returning
                        $formattedData = $products->map(function ($product) {
                            return [
                                'id' => $product->id,
                                'name' => $product->name,
                                'unit' => $product->unit,
                                'group' => $product->Group->name,
                                'image' => $product->image,
                                'hsn_code' => $product->hsn_code,
                                'status' => $product->status,
                                'stock_qty' => $product->stock_qty,
                                'sale_price' => $product->sale_price,
                                'opening_stock' => $product->opening_stock,
                                'part_no' => $product->part_no,
                                'created_at' => $product->created_at,
                                'updated_at' => $product->updated_at,
                            ];
                        });

                        return response()->json(['status' => 'true','msg' => 'All group Id base data','data' => $formattedData,
                        ], 200);
                    }
                }




                public function Category_Show()
                {
                    $category = CategoryMaster::all();

                    if ($category->isEmpty()) {
                        return response()->json(['status' => 'false','msg' => 'Category not found.',], 200);
                    } else
                    {
                        return response()->json(['status' => 'true','msg' => 'All Category retrieved successfully.','data' => $category,
                        ], 200);
                    }
                }




                public function Brand_Show()
                {
                    $brands = BrandMaster::all();

                    if ($brands->isEmpty()) {
                         return response()->json(['status' => 'false','msg' => 'Brands not found.',], 200);
                    } else
                    {
                        return response()->json(['status' => 'true','msg' => 'All Brands retrieved successfully.','data' => $brands,
                        ], 200);
                    }
                }




                




                public function Complain_Store(Request $request)
                {

                    $complains = Complain::create([
                    'product_no' => $request->input('product_no'),
                    'customer_code' => $request->input('customer_code'),
                    'date' => $request->input('date'),
                    'manufacturing_date' => $request->input('manufacturing_date'),
                    'complain' => $request->input('complain'),
                    'user_id' => $request->input('user_id')
                    ]);

                    if ($complains) {
                        return response()->json(['status' =>'true','message' => 'Complain created successfully'], 200);
                    } else {
                        return response()->json(['status' =>'false','message' => 'Failed to create Complain'], 200);
                    }

                }




                public function Complain_Show(Request $request)
                {

                    $this->validate($request,[
                    'user_id'=>'required'
                    ]);

                    $user_id = $request->input('user_id');

                    $complains = Complain::where('user_id', $user_id)->get();

                    if ($complains->isEmpty()) {
                            return response()->json(['status' => 'false','msg' => 'No complains found for the given User ID.',
                             ], 200);
                        } else {
                            return response()->json(['status' => 'true','msg' => 'All User Id base data','data' => $complains,
                            ], 200);
                        }
                }


                        

                public function Attendence_Store(Request $request)
                {
                    config(['app.timezone' => 'Asia/Kolkata']);

                    $user_id = $request->input('user_id');

                    $existingEntry = Attendance::where('user_id', $user_id)
                        ->whereDate('date', Carbon::now()->format('Y-m-d'))
                        ->exists();

                    if ($existingEntry) {
                        return response()->json(['status' => 'false', 'message' => 'Attendance entry for today already exists. Try again tomorrow.'], 200);
                    }

                    $time_in = Carbon::now()->format('H:i:s');
                    $date = Carbon::now()->format('Y-m-d');

                    // Create a new attendance entry
                    $attendance = Attendance::create([
                        'usr_id' => $user_id,
                        'in_longitude' => $request->input('in_longitude'),
                        'in_latitude' => $request->input('in_latitude'),
                        'in_location' => $request->input('in_location'),
                        'time_in' => $time_in,
                        'date' => $date,
                    ]);
 
                    if ($attendance) 
                    {
                        // Fetch the formatted time and date for the response
                        $formattedTimeIn = Carbon::createFromFormat('H:i:s', $attendance->time_in)->format('h:i A');
                        $formattedDate = Carbon::createFromFormat('Y-m-d', $attendance->date)->format('Y-m-d');

                        return response()->json([
                            'status' => 'true',
                            'message' => 'Attendance created successfully',
                            'data' => [
                                'time_in' => $formattedTimeIn,
                                'date' => $formattedDate,
                            ],

                        ], 200);
                    } 
                    else 
                    {
                        return response()->json(['status' => 'false', 'message' => 'Failed to create Attendance'], 200);
                    }
                }


                public function Attendence_Update(Request $request)
                {
                    $user_id = $request->input('user_id');
                    $out_longitude = $request->input('out_longitude');
                    $out_latitude = $request->input('out_latitude');
                    $out_location= $request->input('out_location');

                    config(['app.timezone' => 'Asia/Kolkata']); // Set the timezone to 'Asia/Kolkata'

                    $time_out = Carbon::now()->format('H:i:s'); // Get the current time for time_out

                    // Find the user based on the mobile number
                    $attendance = Attendance::where('usr_id', $user_id)->latest('date')
                    ->latest('created_at')
                    ->first();

                    $attendance->update([
                        'usr_id' => $user_id,
                        'out_longitude' => $out_longitude,
                        'out_latitude' => $out_latitude,
                        'out_location' => $out_location,
                        'time_out' => $time_out // Update the time_out field with the current time
                    ]);

                    // Fetch the formatted time and date for the response
                    $formattedTimeOut = Carbon::createFromFormat('H:i:s', $time_out)->format('h:i A');

                    return response()->json([
                        'status' => 'true',
                        'message' => 'Attendence updated successfully',
                        'data' => [
                            'time_out' => $formattedTimeOut,
                        ],

                    ], 200);
                }


                


                public function Attendence_Day(Request $request)
                {
                    $this->validate($request, [
                        'user_id' => 'required',
                    ]);

                    $user_id = $request->input('user_id');

                    $today = date('Y-m-d'); // Get the current date in the 'Y-m-d' format

                    $attendance = Attendance::where('usr_id', $user_id)
                        ->whereDate('date', '=', $today) // Filter by today's date in 'Y-m-d' format
                        ->latest('created_at')
                        ->first();

                    if (!$attendance) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No Attendance found for the given User ID today.',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'Last Attendance data for the specified user_id',
                            'data' => $attendance,
                        ], 200);
                    }
                }




                public function Attendence_Show(Request $request)
                {

                    $this->validate($request,[
                        'user_id'=>'required'
                    ]);

                    $user_id = $request->input('usr_id');

                    $attendance = Attendance::where('user_id', $user_id)->get();

                    if ($attendance->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No Attendance found for the given User ID.',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All User Id base data',
                            'data' => $attendance,
                        ], 200);
                    }
                }



                public function Order_Save(Request $request)
                {
                    $this->validate($request,[
                        'user_id'=>'required'
                    ]);
                    $params['user_id']=$request->user_id;
                    $params['customer_id']=$request->customer_id;
                    $params['amount']=$request->amount;

                    $order=Order::create($params);

                    if($order)
                    {
                        foreach($request->items as $key=>$value)
                        {
                            $data['order_id']=$order->id;
                            $data['item_id']=$value['id'];
                            $data['name']=$value['name'];
                            $data['price']=$value['price'];
                            $data['qty']=$value['qty'];
                            $data['totalAmt']=$value['totalAmt'];
                            $data['subtotal']=$value['subtotal'];

                            Order_history::create($data);
                        }

                    }

                    if(!$order)
                    {
                        return response()->json(['status'=>'false','msg'=>'order Not Created'], 200);
                    }
                    else
                    {
                        return response()->json(['status'=>'true','msg'=>'Order Created Successfully'], 200);
                    }

                }


               

                public function Order_Show(Request $request)
                {
                    $this->validate($request, [
                        'user_id' => 'required'
                    ]);

                    $user_id = $request->input('user_id');

                    $orders = Order::with('Customer')->where('user_id', $user_id)->get();

                    if ($orders->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No Order found for the given User ID.',
                        ], 200);
                    } else {
                        $formattedOrders = $orders->map(function ($order) {
                            // Get the customer data from the relationship
                            $customer = $order->Customer;

                            if ($customer) {
                                return [
                                    'id' => $order->id,
                                    'user_id' => $order->user_id,
                                    'amount' => $order->amount,
                                    'created_at' => Carbon::parse($order->created_at)->format('d-m-Y'),
                                    'updated_at' => Carbon::parse($order->updated_at)->format('d-m-Y'),
                                    'customer' => [
                                        'customer_id' => $customer->id,
                                        'role' => $customer->role,
                                        'group' => $customer->group,
                                        'name' => $customer->name,
                                        'mobile' => $customer->mobile,
                                        'email' => $customer->email,
                                        'password' => $customer->password,
                                        'status' => $customer->status,
                                        'DOB' => $customer->DOB,
                                    ],
                                ];
                            } else {
                                // If customer doesn't exist, return an object with all fields set to null
                                return [
                                    'id' => $order->id,
                                    'user_id' => $order->user_id,
                                    'amount' => $order->amount,
                                    'created_at' => Carbon::parse($order->created_at)->format('d-m-Y'),
                                    'updated_at' => Carbon::parse($order->updated_at)->format('d-m-Y'),
                                    'customer' => [
                                        'customer_id' => null,

                                    ],
                                ];
                            }
                        });

                        if ($formattedOrders->isEmpty()) {
                            return response()->json([
                                'status' => 'false',
                                'msg' => 'No Order found for the given User ID with matching customers.',
                            ], 200);
                        }

                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All User Id base data',
                            'data' => $formattedOrders,
                        ], 200);
                    }
                }



                public function Order_History_Show($order_id)
                {
                    $order = Order::find($order_id);

                    if (!$order) {
                        return response()->json(['status' => 'false', 'msg' => 'Order Not Found'], 404);
                    }

                    $orderDetails = [
                        'user_id' => $order->user_id,
                        'customer_id' => $order->customer_id,
                        'amount' => $order->amount,
                        'created_at' => Carbon::parse($order->created_at)->format('Y-m-d'),
                    ];

                    $orderHistoryItems = Order_history::where('order_id', $order_id)
                        ->select('item_id', 'name', 'price', 'qty','totalAmt','subtotal')
                        ->get();

                    $items = [];
                    foreach ($orderHistoryItems as $orderHistoryItem) {
                        $item = [
                            'item_id' => $orderHistoryItem->item_id,
                            'name' => $orderHistoryItem->name,
                            'price' => $orderHistoryItem->price,
                            'qty' => $orderHistoryItem->qty,
                            'totalAmt' => $orderHistoryItem->totalAmt,
                            'subtotal' => $orderHistoryItem->subtotal,
                        ];
                        $items[] = $item;
                    }

                    $orderDetails['items'] = $items;

                    return response()->json([
                        'status' => 'true',
                        'msg' => 'List of Orders History',
                        'data' => $orderDetails,
                    ], 200);
                }

               

                public function HomeBanner_Show()
                {
                    $slider = Slider::all();

                    if ($slider->isEmpty()) {
                        return response()->json(['status' => 'false','msg' => 'Slider not found.',], 200);
                    } else
                    {
                        return response()->json(['status' => 'true','msg' => 'All Slider retrieved successfully.','data' => $slider,
                        ], 200);
                    }

                }

                public function Report_Save(Request $request)
                {
                    $user_id = $request->input('user_id');
                    $date = $request->input('date');
                    $message = $request->input('message');

                    // Check if a report exists for the given user and date
                    $report = Report::where('user_id', $user_id)
                                ->where('date', $date)
                                ->first();

                    if ($report) {
                        // If a report already exists, update the message
                        $report->update([
                            'message' => $message
                        ]);

                        return response()->json(['status' =>'true','message' => 'Report updated successfully'], 200);
                    } else {
                        // If no report exists, create a new one
                        $newReport = Report::create([
                            'user_id' => $user_id,
                            'date' => $date,
                            'message' => $message
                        ]);

                        if ($newReport) {
                            return response()->json(['status' =>'true','message' => 'Report created successfully'], 200);
                        } else {
                            return response()->json(['status' =>'false','message' => 'Failed to create Report'], 200);
                        }
                    }
                }

                public function Report_Show(Request $request)
                {
                    $this->validate($request,[
                        'user_id'=>'required'
                    ]);

                    $user_id = $request->input('user_id');

                    $reports = Report::where('user_id', $user_id)->get();

                    if ($reports->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No Report found for the given User ID.',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All User Id base data',
                            'data' => $reports,
                        ], 200);
                    }
                }

                public function Report_Day(Request $request)
                {
                    $this->validate($request, [
                        'user_id' => 'required',
                    ]);

                    $user_id = $request->input('user_id');

                    $today = date('Y-m-d'); // Get the current date in the 'Y-m-d' format

                    $reports = Report::where('user_id', $user_id)
                        ->whereDate('date', '=', $today) // Filter by today's date in 'Y-m-d' format
                        ->latest('created_at')
                        ->first();

                    if (!$reports) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No Report found for the given User ID today.',
                        ], 200);
                    } else {
                        return response()->json([
                            'status' => 'true',
                            'msg' => 'Last Report data for the specified user_id',
                            'data' => $reports,
                        ], 200);
                    }
                }


                public function Suggestion_Store(Request $request)
                {

                    $suggestions = Suggestion::create([
                    'user_id' => $request->input('user_id'),
                    'message' => $request->input('message')
                    ]);

                    if ($suggestions) {
                        return response()->json(['status' =>'true','message' => 'Suggestions created successfully'], 200);
                    } else {
                        return response()->json(['status' =>'false','message' => 'Failed to create Suggestions'], 200);
                    }

                }


                public function Suggestion_Show(Request $request)
                {
                    $this->validate($request, [
                        'user_id' => 'required'
                    ]);

                    $user_id = $request->input('user_id');

                    $suggestions = Suggestion::where('user_id', $user_id)->get();

                    if ($suggestions->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'No suggestions found for the given User ID.',
                        ], 200);
                    } else {
                        $formattedSuggestions = $suggestions->map(function ($suggestion) {
                            return [
                                'id' => $suggestion->id,
                                'user_id' => $suggestion->user_id,
                                'message' => $suggestion->message,
                                'created_at' => Carbon::parse($suggestion->created_at)->format('Y-m-d'),
                            ];
                        });

                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All User Id base data',
                            'data' => $formattedSuggestions,
                        ], 200);
                    }
                }


                public function Suggestion_Delete(Request $request)
                {

                    $id = $request->input('id');

                    $suggestions = Suggestion::where('id', $id)->first();
                    if ($suggestions) {
                        $suggestions->delete();
                        return response()->json(['status'=>'true','message' => 'Suggestion deleted successfully'], 200);
                    }
                    return response()->json(['status'=>'false','error' => 'Suggestion not found'], 200);
                }


            

                public function InfoAlert_Show()
                {
                    $info_alerts = InfoAlert::all();

                    if ($info_alerts->isEmpty()) {
                        return response()->json([
                            'status' => 'false',
                            'msg' => 'info_alerts not found.',
                        ], 200);
                    } else {
                        $formattedInfoAlerts = $info_alerts->map(function ($info_alert) {
                            return [
                                'id' => $info_alert->id,
                                'message' => strip_tags($info_alert->message),
                                'created_at' => Carbon::parse($info_alert->created_at)->format('Y-m-d'),
                            ];
                        });

                        return response()->json([
                            'status' => 'true',
                            'msg' => 'All info_alerts retrieved successfully.',
                            'data' => $formattedInfoAlerts,
                        ], 200);
                    }
                }

        public function my_attendance_post($id)
        {

                $sdate=date("Y-m-d", strtotime(" -1 months"));
                $edate=date('Y-m-d');
                $usr_id=User::find($id);
               
                $attendance = Attendance::where('usr_id',$usr_id->id)->where('time_status','1')->get();
             
                if($attendance)
                {   
                    $leave_dates=$this->getDatesFromRange($sdate, $edate);

                         $atten_date = array();
                         foreach ($attendance as $row) 
                         {
                            $atten_date[]=$row->date;
                            $row->day=$day = date('l', strtotime($row->date));
                            $row->label='';
                         }

                         $date_range = array_merge(array_diff($leave_dates, $atten_date));

                         $attendance=array();

                         foreach ($leave_dates as $leave_value) {   

                            if(in_array($leave_value,$atten_date))
                            {
                                $day = date('l', strtotime($leave_value));
                                $attendance[] = (object) array( 'id'=>'', 'usr_id'=>$usr_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'',  'day' => $day, 'label' => 'attendance' ); 
                            }

                            if( !in_array( $leave_value, $date_range ))
                            {
                                continue;
                            }
                            
                            if( date('l', strtotime($leave_value)) == 'Sunday' ){
                                $attendance[] = (object) array( 'id'=>'', 'usr_id'=>$usr_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'',  'day' => 'Sunday', 'label' => 'Holiday' ); 
                            }else{

                                $leave_check=Leave::where('usr_id',$usr_id->id)->where('start_date','<=', $leave_value)->where('end_date','>=', $leave_value)->where('status','1')->get();



                                // if($leave_check)
                                if(count($leave_check)!=0)
                                {
                                    $day = date('l', strtotime($leave_value));
                                    $attendance[] = (object) array( 'id'=>'', 'usr_id'=>$usr_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'', 'day' => $day, 'label' => 'Leave' );
                                }
                                else
                                {
                                    $day = date('l', strtotime($leave_value));
                                    $attendance[] = (object) array('id'=>'', 'usr_id'=>$usr_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'', 'day' => $day, 'label' => 'Absent' );
                                }
                            }
                         }


                         $wek=array();
                        foreach ($attendance as $key => $row)
                        {
                            $wek[$key]  = $row->date;
                        }    
         
                        // // Sort the data with wek ascending order, add $mar as the last parameter, to sort by the common key
                        array_multisort($wek, $attendance);
                      

                        return response()->json([
                        'status' => true,
                        'message' => "attendance",
                        'response'=>$attendance
                        ],200);
                }
                else
                {
                    return response()->json([
                    'status' => false,
                    'message' => "No record found!",
                    ],404);
                }
            }

            // Function to get all the dates in given range 
            public function getDatesFromRange($start, $end, $format = 'Y-m-d') 
            { 
                  
                // Declare an empty array 
                $array = array(); 
                // Variable that store the date interval 
                // of period 1 day 
                $interval = DateInterval::createFromDateString('1 day');
                $realEnd = new DateTime($end); 
                $realEnd->add($interval); 
                $period = new DatePeriod(new DateTime($start), $interval, $realEnd); 
                // Use loop to store date into array 
                foreach($period as $date) {                  
                    $array[] = $date->format($format);  
                } 
                // Return the array elements 
                return $array; 
            }


            public function ShopSave(Request $request)
            {
                $request->validate([
                'email'=>'required|email|unique:users,email',
                 ]);

                $params['name']=$request->name;
                $params['email']=$request->email;
                $params['mobile']=$request->mobile;
                $params['DOB']=$request->dob;
                $params['code']=$request->code;
                $params['role']=$request->role;
                $params['password']=Hash::make($request->password);
                $params['state']=$request->state;
                $params['city']=$request->city;
                $params['address']=$request->address;
                $user=User::create($params);
                
                $user->assignRole($request->role);
                return redirect()->route('allShops')->with('success','successfully registration..');
            }





}




