@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Add NEW USER</h3>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('showallusers')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left text-primary">

                <i class="fa fa-arrow-left color-primary"></i>

            </span>Back

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('user.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Name">
                                  <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Mobile<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="mobile" value="{{old('mobile')}}" placeholder="Enter Mobile No">
                                    <span class="text-danger"> @error('mobile'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{old('email')}}" placeholder="Enter Email Id">
                                    <span class="text-danger"> @error('email'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Password<span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" value="{{old('password')}}" placeholder="Enter password Id">
                                    <span class="text-danger"> @error('password'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                     <select class=" form-control dropdown-toggle" name="role" type="button" data-toggle="dropdown">
                                        <option value="">Select Role</option>
                                        @foreach($role as $rol)
                                          <option value="{{$rol->name}}">{{$rol->name}}</option>
                                          @endforeach
                                      </select>
                                    <span class="text-danger">@error('role'){{ $message }}@enderror</span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>DOB<span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="dob" value="{{old('dob')}}" placeholder="Enter date of birth">
                                    <span class="text-danger"> @error('dob'){{ $message }}@enderror </span>
                                </div>


                                <div class="text-center">
                                    <button type="submit"  class="btn btn-primary" style="margin-right:7px;">Submit</button>
                                    <a href="{{url('/showallusers')}}"><button type="button" class="btn btn-primary">Cancel</button></a>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->

<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>
 @endsection



