@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Employee Registration</h3>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('employees')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left text-primary">

                <i class="fa fa-arrow-left color-primary"></i>

            </span>Back

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('user.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Name">
                                  <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Mobile<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="mobile" value="{{old('mobile')}}" placeholder="Enter Mobile No">
                                    <span class="text-danger"> @error('mobile'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{old('email')}}" placeholder="Enter Email Id">
                                    <span class="text-danger"> @error('email'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Password<span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" value="{{old('password')}}" placeholder="Enter password Id">
                                    <span class="text-danger"> @error('password'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                     <select class=" form-control dropdown-toggle" name="role" type="button" data-toggle="dropdown">
                                        <option value="">Select Role</option>
                                        @foreach($role as $rol)
                                          <option value="{{$rol->name}}">{{$rol->name}}</option>
                                          @endforeach
                                      </select>
                                    <span class="text-danger">@error('role'){{ $message }}@enderror</span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>DOB<span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="dob" value="{{old('dob')}}" placeholder="Enter date of birth">
                                    <span class="text-danger"> @error('dob'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Address<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="address" value="{{old('address')}}" placeholder="Enter Address">
                                    <span class="text-danger"> @error('address'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="country">Country<span class="text-danger">*</span></label>
                                    <select class="form-control" id="country-dropdown" name="country">
                                    <option value="">Select Country</option>
                                     @foreach ($countries as $country)
                                    <option value="{{$country->id}}">
                                    {{$country->name}}
                                    </option>
                                    @endforeach
                                    </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                    <label for="state">State<span class="text-danger">*</span></label>
                                    <select class="form-control" id="state-dropdown" name="state">
                                    </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                    <label for="city">City<span class="text-danger">*</span></label>
                                    <select class="form-control" id="city-dropdown" name="city">
                                    </select>
                                    </div>

                                <div class="form-group col-lg-6">
                                    <label>Pincode<span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="pincode" value="{{old('pincode')}}" placeholder="Enter Pincode">
                                    <span class="text-danger"> @error('pincode'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>GST No Customer<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="gst" value="{{old('gst')}}" placeholder="Enter GST No">
                                    <span class="text-danger"> @error('gst'){{ $message }}@enderror </span>
                                </div>


                                <div class="form-group col-lg-6">
                                    <label>Pancard No<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="pancard" value="{{old('pancard')}}" placeholder="Enter pancard No">
                                    <span class="text-danger"> @error('pancard'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Bussiness Type<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="bussiness" value="{{old('bussiness')}}" placeholder="Enter Bussiness Type">
                                    <span class="text-danger"> @error('bussiness'){{ $message }}@enderror </span>
                                </div>


                                <div class="form-group col-lg-12">

                                    <label>Bank Details <span class="text-danger">*</span></label>

                                    <textarea class="form-control ckeditor" name="bank_detail" placeholder="Enter Bank Details"></textarea>

                                    <span class="text-danger"> @error('bank_detail'){{ $message }}@enderror </span>

                                </div>


                                <div class="text-center">
                                    <button type="submit"  class="btn btn-primary" style="margin-right:7px;">Submit</button>
                                    <a href="{{url('/showallusers')}}"><button type="button" class="btn btn-primary">Cancel</button></a>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>

<script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var country_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"{{url('get-states-by-country')}}",
    type: "POST",
    data: {
    country_id: country_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#state-dropdown').html('<option value="">Select State</option>');
    $.each(result.states,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    $('#city-dropdown').html('<option value="">Select State First</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var state_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"{{url('get-cities-by-state')}}",
    type: "POST",
    data: {
    state_id: state_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#city-dropdown').html('<option value="">Select City</option>');
    $.each(result.cities,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    }
    });
    });
    });
    </script>
 @endsection

 <script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var country_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"{{url('get-states-by-country')}}",
    type: "POST",
    data: {
    country_id: country_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $.each(result.states,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    $('#city-dropdown').html('<option value="">Select State First</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var state_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"{{url('get-cities-by-state')}}",
    type: "POST",
    data: {
    state_id: state_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $.each(result.cities,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    }
    });
    });
    });
    </script>



