<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AddProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'unit',
        'price',
        'brand',
        'category',
        'group',
        'image',
        'description'
    ];

    public function Category(){
        return $this->hasOne(CategoryMaster::class,'id','category');
    }
    public function Brand(){
        return $this->hasOne(BrandMaster::class,'id','brand');
    }

    public function Group(){
        return $this->hasOne(Groups::class,'id','group');
    }
}
