<?php

namespace App\Http\Controllers;

use App\Models\{BrandMaster,CategoryMaster,AddProduct,Groups};
use Illuminate\Http\Request;

class AddProductController extends Controller
{
    public function index(Request $request)
    {
        if($request->search){
            $add_products = AddProduct::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);
        } else
        {
            $add_products = AddProduct::orderBy('id','DESC')->paginate(10);
        }
        return view('product.index',compact('add_products','request'));
    }

    public function create(){
        $brand_masters=BrandMaster::get(['name','id']);
        $category_masters=CategoryMaster::get(['name','id']);
        $groups=Groups::get(['name','id']);

        return view('product.create',compact('brand_masters','category_masters','groups'));
}

        public function store(Request $request)
        {
            $this->validate($request,[
                'name' => 'required',
                'unit' => 'required',
                'price' => 'required',
                'brand' => 'required',
                'category' => 'required',
                'group' => 'required',
                'image' => 'required',
                'description' => 'required',
            ]);

            if ($request->hasFile('image'))
            {
                $imageName = time() . '.' . $request->image->extension();

                $path = $request->image->move(public_path('/uploads/product/'), $imageName);

                $data['image'] = $imageName;
            }
                $data['name'] = $request->name;
                $data['unit'] = $request->unit;
                $data['price'] = $request->price;
                $data['group'] = $request->group;
                $data['description'] = $request->description;
                $data['brand'] = $request->brand;
                $data['category'] = $request->category;

                $product = AddProduct::create($data);

                if ($product ) {
                    return redirect('products')->with('success', 'Add Product created successfully.');
                } else {
                    return redirect('products')->with('error', 'Something went wrong.');
                }
            }

            public function edit($id)
            {
                $id=decrypt($id);

                $brand_masters=BrandMaster::get(['name','id']);
                $groups=Groups::get(['name','id']);
                $category_masters=CategoryMaster::get(['name','id']);
                $product = AddProduct::find($id);

                return view('product.edit',compact('product','brand_masters','category_masters','groups'));
            }

                public function update(Request $request, $id)
                {
                    $this->validate($request,[
                        'name' => 'required',
                        'unit' => 'required',
                        'price' => 'required',
                    ]);

                    $product= AddProduct::find($id);

                    $data = [
                        'name' => $request->name,
                        'unit' => $request->unit,
                        'price' => $request->price,
                        'brand' => $request->brand,
                        'category' => $request->category,
                        'group' => $request->group,
                        'description' => $request->description,
                    ];

                    if ($request->hasFile('image'))
                    {
                        $imageName = time() . '.' . $request->image->extension();

                        $path = $request->image->move(public_path('/uploads/product/'), $imageName);

                        $data['image'] = $imageName;
                    }


                    $product->update($data);

                    return redirect('products')->with('success', 'Brand Master  updated successfully.');
                }


                public function delete($id)
                {
                    $id=decrypt($id);

                    $product=AddProduct::find($id);

                    $product->delete();

                    return redirect('products')->with('error','Product deleted successfully.');
                }


}
