<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\{RoleController,AdminController,CompanyServiceController,UserController};
use App\Models\{Country,City,State,Company,Invoice,Currency,AllCurrency,Lead,Source,User,GroupUsers,Group,ServiceInvoice};
use App\Http\Middleware\Authenticate;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/forgetpassword',[CompanyServiceController::class,'ShowForgetPasswordForm'])->name('forget.password.get');
Route::post('forgetpassword',[CompanyServiceController::class,'SubmitForgetPasswordForm'])->name('forget.password.post');

Route::get('resetpassword',[CompanyServiceController::class,'ShowResetPasswordForm'])->name('reset.password.get');
Route::post('resetpassword',[CompanyServiceController::class,'SubmitResetPasswordForm'])->name('reset.password.post');


Route::group(['middleware'=>['auth']],function(){
    Route::get('/index',[AdminController::class,'Dashboard']);

});

Route::get('/', function () {
    if(Auth::check())
    {
        return redirect('/index');
    }
    else
    {
        $companies=Company::get()->first();
        $logo=$companies->logo;
        Session::put('logo',$logo);
        return view('frontend.pages-login');
    }
})->name('/');

Route::post('/signed',[AdminController::class,'signIn'])->name('signed');

Route::get('regist', function () {
    return view('frontend.pages-register');
});

Route::group(['middleware' => ['auth']], function() {
   /**
   * Logout Route
   */
   Route::post('/logout',[LoginController::class,'logout']);

});

Route::group(['middleware'=>['auth']],function(){

Route::resource('admin',AdminController::class);

//Roles And Permissions

// Route::post('/add-permission',[AdminController::class,'addPermis']);
// Route::view('forms-permission',"frontend.forms-layouts");

Route::resource('role',RoleController::class);

Route::get('/addroles',[RoleController::class,'index'])->name('addroles');

Route::post('/role-submit',[RoleController::class,'submitRole']);

Route::get('/permissions/{id}',[RoleController::class,'show_permission']);

Route::post('/role-edit/{id}',[RoleController::class,'roleEdit']);

Route::get('/deleterole/{id}',[RoleController::class,'delete_Role']);

Route::get('onchangerole/{id}',[RoleController::class,'ChangeRole']);

Route::get('permis',function(){
    $role=Session::get('roles');
    $roles=Role::all();
    $permissions=Permission::all();
    $rolePermissions = $role->permissions->pluck('id')->toArray();

    $role_permission = Permission::all();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, "."));

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }

        }

    return view('frontend.permis',compact('role','roles','permissions','rolePermissions','custom_permission'));
});

// Users

Route::get('/showallusers',[UserController::class,'AllUsers'])->name('showallusers');

Route::get('/users-profile',[AdminController::class,'UserProfile'])->name('users-profile');

Route::post('/user-edit/{id}',[UserController::class,'EditUser']);

Route::get('/addnewuser',[UserController::class,'NewUser'])->name('addnewuser');

Route::POST('/user/store', [UserController::class,'User_Store'])->name('user.store');


//Group Routes

Route::get('/newgroup',[UserController::class,'NewGroup'])->name('newgroup');

Route::post('/savegroup',[UserController::class,'SaveGroup']);

Route::post('/group-edit/{id}',[UserController::class,'EditGroup']);

Route::get('/groupstatus/{id}',[UserController::class,'GroupStatus']);

Route::get('/group-users/{id}',[UserController::class,'Group_users']);

Route::get('/memberofgroup',function()
{
    $group=Session::get('group');

    $users=User::all();

    $allgroupusers=GroupUsers::where('group_id',$group->id)->pluck('user_id')->toArray();

    return view('frontend.groupMember',compact('allgroupusers','users','group'));

})->name('/memberofgroup');

Route::post('/add-groupuser/{id}',[UserController::class,'AddGroupUser']);

Route::POST('/login-with-user/{id}',[UserController::class,'UserLogin'])->name('login-with-user');



Route::view('components-view',"frontend.components-view");

Route::get('currency-page',[AdminController::class,'Currencyfun']);
Route::post('storecurrency',[AdminController::class,'SetCurrency']);
Route::post('/addnewcurrency',[AdminController::class,'AddCurrency']);
Route::get('/deletecurrency/{id}',[AdminController::class,'deleteCurrency']);

Auth::routes();

//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::resource('salesorder',CompanyServiceController::class);

Route::post('/searchlead',[AdminController::class,'Search']);

Route::get('/serviceinvoice',[CompanyServiceController::class,'ShowServiceInvoice']);

Route::post('/saveremarklead/{id}',[CompanyServiceController::class,'RemarkSave']);

Route::get('/remarkdelete/{id}',[CompanyServiceController::class,'RemarkDelete']);

Route::post('/editremark/{id}',[CompanyServiceController::class,'EditRemark']);

Route::get('/importfile-pages',[CompanyServiceController::class,'ImportView']);

Route::post('/importdata',[CompanyServiceController::class,'DataImport'])->name('importdata');



// Group  start

Route::get('/groups', [App\Http\Controllers\GroupController::class,'index'])->name('groups');

Route::get('/group/create', [App\Http\Controllers\GroupController::class,'create'])->name('group.create');

Route::post('/group/store', [App\Http\Controllers\GroupController::class,'store'])->name('group.store');

Route::get('/group/edit/{id}', [App\Http\Controllers\GroupController::class,'edit'])->name('group.edit');

Route::post('/group/update/{id}', [App\Http\Controllers\GroupController::class,'update'])->name('group.update');

Route::get('/group/delete/{id}', [App\Http\Controllers\GroupController::class,'delete'])->name('group.delete');


// Employee Info  start

Route::get('/employees', [App\Http\Controllers\EmployeeInfoController::class,'index1'])->name('employees');

Route::get('country-state-city', [App\Http\Controllers\EmployeeInfoController::class, 'index']);

Route::post('get-states-by-country', [App\Http\Controllers\EmployeeInfoController::class, 'getState']);

Route::post('get-cities-by-state', [App\Http\Controllers\EmployeeInfoController::class, 'getCity']);

Route::get('/category/create', [App\Http\Controllers\CategoryMasterController::class,'create'])->name('category.create');

Route::post('/category/store', [App\Http\Controllers\CategoryMasterController::class,'store'])->name('category.store');

Route::get('/category/edit/{id}', [App\Http\Controllers\CategoryMasterController::class,'edit'])->name('category.edit');

Route::post('/category/update/{id}', [App\Http\Controllers\CategoryMasterController::class,'update'])->name('category.update');

Route::get('/category/delete/{id}', [App\Http\Controllers\CategoryMasterController::class,'delete'])->name('category.delete');


 // Add Product start


Route::get('/products', [App\Http\Controllers\AddProductController::class,'index'])->name('products');

Route::get('/addproduct/create', [App\Http\Controllers\AddProductController::class,'create'])->name('addproduct.create');

Route::post('/addproduct/store', [App\Http\Controllers\AddProductController::class,'store'])->name('addproduct.store');

Route::get('/products/edit/{id}', [App\Http\Controllers\AddProductController::class,'edit'])->name('products.edit');

Route::post('/products/update/{id}', [App\Http\Controllers\AddProductController::class,'update'])->name('products.update');

Route::get('/products/delete/{id}', [App\Http\Controllers\AddProductController::class,'delete'])->name('products.delete');


// Brand Master  start

Route::get('/brandmaster', [App\Http\Controllers\BrandMasterController::class,'index'])->name('brandmaster');

Route::get('/brandmaster/create', [App\Http\Controllers\BrandMasterController::class,'create'])->name('brandmaster.create');

Route::post('/brandmaster/store', [App\Http\Controllers\BrandMasterController::class,'store'])->name('brandmaster.store');

Route::get('/brandmaster/edit/{id}', [App\Http\Controllers\BrandMasterController::class,'edit'])->name('brandmaster.edit');

Route::post('/brandmaster/update/{id}', [App\Http\Controllers\BrandMasterController::class,'update'])->name('brandmaster.update');

Route::get('/brandmaster/delete/{id}', [App\Http\Controllers\BrandMasterController::class,'delete'])->name('brandmaster.delete');


// Category Master  start

Route::get('/category', [App\Http\Controllers\CategoryMasterController::class,'index'])->name('category');

Route::get('/category/create', [App\Http\Controllers\CategoryMasterController::class,'create'])->name('category.create');

Route::post('/category/store', [App\Http\Controllers\CategoryMasterController::class,'store'])->name('category.store');

Route::get('/category/edit/{id}', [App\Http\Controllers\CategoryMasterController::class,'edit'])->name('category.edit');

Route::post('/category/update/{id}', [App\Http\Controllers\CategoryMasterController::class,'update'])->name('category.update');

Route::get('/category/delete/{id}', [App\Http\Controllers\CategoryMasterController::class,'delete'])->name('category.delete');


// complain  start

Route::get('/complain/index', [App\Http\Controllers\ComplainController::class,'index'])->name('complain.index');


});


