@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Product</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('products')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left text-primary">

                <i class="fa fa-arrow-left color-primary"></i>

            </span>Back

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                        <form action="{{route('products.update',$product->id)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">
                            <div class="form-group col-lg-6">

                                <label>Name <span class="text-danger">*</span></label>

                                <input type="text" class="form-control" name="name" value="{{ $product->name }}" placeholder="Name">

                                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Unit <span class="text-danger">*</span></label>

                                <input type="text" class="form-control" name="unit" value="{{ $product->unit }}" placeholder="Unit">

                                <span class="text-danger"> @error('unit'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Price <span class="text-danger">*</span></label>

                                <div class="input-group mb-2">

                                    <input type="number" class="form-control" name="price" value="{{ $product->price }}" placeholder="Price" >

                                </div>

                                <span class="text-danger"> @error('price'){{ $message }}@enderror </span>

                            </div>



                             <div class="form-group col-lg-6">
                                <label>Brand <span class="text-danger">*</span></label>
                                <select class=" form-control dropdown-toggle" type="button" name="brand" data-toggle="dropdown">
                                    <option value="">Select Brand</option>
                                     @foreach($brand_masters as $brand)
                                     <option value="{{$brand->id}}" {{$brand->id==$product->brand?'selected':''}}>{{$brand->name}}</option>
                                 @endforeach
                                </select>
                                <span class="text-danger">@error('brand'){{ $message }}@enderror</span>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>Category <span class="text-danger">*</span></label>
                                <select class=" form-control dropdown-toggle" name="category" type="button" data-toggle="dropdown">
                                    <option value="">Select Category</option>
                                     @foreach($category_masters as $category)
                                     <option value="{{$category->id}}" {{$category->id==$product->category?'selected':''}}>{{$category->name}}</option>
                                 @endforeach
                                </select>
                                <span class="text-danger">@error('category'){{ $message }}@enderror</span>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>Group <span class="text-danger">*</span></label>
                                <select class=" form-control dropdown-toggle" name="group" type="button" data-toggle="dropdown">
                                    <option value="">Select Group</option>
                                     @foreach($groups as $group)
                                     <option value="{{$group->id}}" {{$group->id==$product->group?'selected':''}}>{{$group->name}}</option>
                                 @endforeach
                                </select>
                                <span class="text-danger">@error('group'){{ $message }}@enderror</span>
                            </div>


                            <div class="form-group col-lg-6">

                                <label>Image</label>

                                <input type="file" class="form-control" name="image" id="image">
                                @if($product->image)
                                <img src="{{ url('/uploads/product/'.$product->image) }}" id="preview-image-before-upload" class="mt-2" height="100">
                                @else
                                <img id="preview-image-before-upload" height="100" class="mt-2">
                                @endif

                            </div>

                                <div class="form-group col-lg-12">
                                <label>Short Description <span class="text-danger">*</span></label>
                                <textarea class="form-control ckeditor" name="description" placeholder="Description">{{ $product->description }}</textarea>
                                <span class="text-danger"> @error('description'){{ $message }}@enderror </span>
                               </div>
                        </div>

                        <div class="text-center">

                            <button type="submit" class="btn btn-success">Submit</button>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

      </div>
</main><!-- End #main -->
 @endsection

 <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
 <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

