@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">Group</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="{{url('group/create')}}">

                    <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                        <span class="btn-icon-left text-primary">

                            <i class="fa fa-plus color-primary"></i>

                        </span>
                       + Add Group

                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        @include('flash_msg')

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form method="GET" action="">

                            <div class="row text-right">

                                <div class="col-md-6"></div>

                                <div class="col-md-4">

                                    <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by Group Name">

                                </div>

                                <div class="col-md-2">

                                    <label class="">&nbsp;</label>

                                    <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                                </div>

                            </div>

                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Image</th>

                                        <th>Group Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    @if(!empty($groups))

                                    @foreach($groups as $key=>$value)

                                    <tr>

                                        <td>{{ ++$key }}</td>


                                        <td>

                                            @if($value->image)
                                            <img src="{{ url('/uploads/groups/'.$value->image) }}" height="50" width="50">
                                            @endif

                                        </td>

                                        <td>{{ $value->name }}</td>

                                        <td class="text-right">

                                            <a href="{{ route('group.edit',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                            <a href="{{ route('group.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                            </td>

                                        </tr>

                                    @endforeach

                                        @if ($groups->count() == 0)

                                        <tr class="text-center">

                                            <td colspan="6">No Brand Master to display.</td>

                                        </tr>

                                        @endif

                                    @endif

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Image</th>

                                        <th>Group Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying {{$groups->count()}} of {{ $groups->total() }} Groups.</p>

                        </div>

                        {{-- <div class="text-right float-right">

                            {{ $projects->appends(request()->all())->links() }}

                        </div> --}}



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 @endsection
