<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User,Group,GroupUsers};
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;

class UserController extends Controller
{
   public function  AllUsers(Request $request)
   {
        $users=User::orderby('id','desc')->get();
          $roles=Role::all();
       if($request->search){
           $users = User::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);
       } else
       {
           $users = User::orderBy('id','DESC')->paginate(10);
       }
       return view('frontend.users-view',compact('users','request','roles'));
   }

    public function EditUser($id,Request $request){
    $user=User::find($id);
    $user->assignRole($request->role);
    User::where('id',$id)->
    update([
        'name'=>$request->name,
        'role'=>$request->role,
        'email'=>$request->email,
        'mobile'=>$request->mobile,
        'DOB'=>$request->dob,
    ]);
    return redirect()->route('showallusers');
   }

   public function NewUser()
   {
    $role=Role::all();
    return view('frontend.newuser',compact('role'));
   }

   public function User_Store(Request $request)
   {

     if($request->newpassword)
       {

        if((Hash::check($request->password,Auth::user()->password))&&($request->newpassword==$request->renewpassword))
         {
            User::where('id',Auth::user()->id)->
            update([

                'password'=>Hash::make($request->newpassword),

            ]);
            return redirect()->route('users-profile')->with('success','Password update successfully...');
         }
          return redirect()->route('users-profile')->with('success','Password is incorrect');
       }

        if($request->profile)
        {
            if($request->file('profile')){
                $file= $request->file('profile');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }

            $id=Auth::user()->id;
            User::where('id',$id)->
                update([

                    'profile'=>$filename,

                ]);
           return redirect()->route('users-profile')->with('success','Profile Update Successfully');
        }
       else
        {
            $request->validate([
                'email'=>'required|email|unique:users,email',
            ]);

            $params['name']=$request->name;
            $params['email']=$request->email;
            $params['mobile']=$request->mobile;
            $params['DOB']=$request->dob;
            $params['role']=$request->role;
            $params['password']=Hash::make($request->password);
            $user=User::create($params);
            $user->assignRole($request->role);
            return redirect()->route('showallusers')->with('success','successfully registration..');
       }

   }

   public function NewGroup()
   {
    $groups=Group::orderby('id','desc')->get();
    $users=User::all();
    return view('frontend.newgroup',compact('groups','users'));
   }

   public function SaveGroup(Request $request)
   {

    $params['name']=$request->name;
    $params['group_manager']=$request->group_manager;
    $group=Group::create($params);
    if($group){
        User::where('id',$request->group_manager)
        ->update([
            'group_id'=>$group->id,
        ]);
    }
    return redirect()->route('newgroup')->with('success','Group Create Successfully');
   }

    public function EditGroup($id,Request $request)
    {
    Group::where('id',$id)->
    update([
        'name'=>$request->name,
        'group_manager'=>$request->group_manager,
    ]);

    User::where('id',$request->group_manager)
        ->update([
            'group_id'=>$id,
        ]);
    return redirect()->route('newgroup')->with('success','Group Edit Successfully');
   }

    public function GroupStatus($group_id){
    $id=$group_id;
    $data = Group::find($id);
    if($data->status=='1'){
        $status = '0';
    } else {
        $status = '1';
    }
    $data->update([
                'status'=>$status,
            ]);
    return redirect()->route('newgroup')->with('success','Group Status Update Successfully');
   }

   public function Group_users($id)
   {
    $group=Group::find($id);
    Session::put('group',$group);
    return redirect('/memberofgroup');
   }

   public function AddGroupUser($id,Request $request)
   {
    $groupid=GroupUsers::where('group_id',$id)->get();
    if($groupid){
        $alluser=GroupUsers::where('group_id',$id)->delete();
        if($request->user){
            foreach ($request->user as $key => $value) {
               $params['group_id']=$id;
               $params['user_id']=$value;
               GroupUsers::create($params);
               User::where('id',$value)
               ->update([
                   'group_id'=>$id,
                ]);
            }
        }
    }
    else{
        if($request->user){
            foreach ($request->user as $key => $value) {
               $params['group_id']=$id;
               $params['user_id']=$value;
               GroupUsers::create($params);
                User::where('id',$value)
               ->update([
                   'group_id'=>$id,
                ]);
            }
        }
    }
   return redirect()->route('newgroup')->with('success','Member Added Successfully');
   }

    public function UserLogin(Request $request, $id){

        Auth::logout();

        Auth::loginUsingId($id);

        return redirect('/index');
    }


}
