<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Groups;

class GroupController extends Controller
{
    public function index(Request $request){

        if($request->search){

            $groups = Groups::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $groups = Groups::orderBy('id','DESC')->paginate(10);
        }

        return view('group.index',compact('groups','request'));
    }

    public function create()
    {

        return view('group.create');

    }
    public function store(Request $request)
    {

        $this->validate($request,[
            'name' => 'required',
            'image' => 'required',
        ]);

        if($request->hasFile('image'))
        {
            $imageName = time().'.'.$request->image->extension();

            $path = $request->image->move(public_path('/uploads/groups/'), $imageName);

            $data['image'] = $imageName;
        }
            $data['name'] = $request->name;

            $groups = Groups::create($data);

            if ($groups ) {
                return redirect('groups')->with('success', 'Groups created successfully.');
            } else {
                return redirect('groups')->with('error', 'Something went wrong.');
            }
        }

            public function edit($id)
        {
            $id=decrypt($id);

            $groups = Groups::find($id);

            return view('group.edit',compact('groups'));
        }

            public function update(Request $request, $id)
            {
                $this->validate($request,[
                    'name' => 'required',
                ]);

                $groups= Groups::find($id);

                $data = [

                    'name' => $request->name,
                ];


            if ($request->hasFile('image'))
            {
                $imageName = time() . '.' . $request->image->extension();

                $path = $request->image->move(public_path('/uploads/groups/'), $imageName);

                $data['image'] = $imageName;
            }

                $groups->update($data);

                return redirect('groups')->with('success', 'Group  updated successfully.');
            }


            public function delete($id)
            {
                $id=decrypt($id);

                $groups = Groups::find($id);

                $groups->delete();

                return redirect('groups')->with('error','Group deleted successfully.');
            }
}
