<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">Farmer Orders</h3>

                </div>

            </div>

            <!-- <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="<?php echo e(url('group/create')); ?>">

                    <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                        <span class="btn-icon-left" style="color: white">+ Add Group</span>


                    </button>

                </a>

            </div> -->

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form action="<?php echo e(route('farmer_order_filter')); ?>" method="get">
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label>Farmer Code</label>
                                    <input type="text" name="farmer_code_filter" class="form-control" placeholder="Search With Farmer Code" value="<?php echo e($request->farmer_code_filter); ?>">
                                </div>
                                
                                <div class="col-md-3 form-group">
                                   <label>Date From</label> 
                                   <input type="date" name="date_from" class="form-control" value="<?php echo e($request->date_from); ?>">

                                </div>
                                <div class="col-md-3 form-group">
                                   <label>Date To</label>
                                   <input type="date" name="date_to" class="form-control" value="<?php echo e($request->date_to); ?>">

                                </div>

                                <div class="col-md-2 form-group mt-4">
                                   
                                    <input type="submit" class="btn btn-primary" value="Filter">

                                </div>
                            </div>
                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Shop Name</th>

                                        <th>Farmer Code</th>

                                        <th>Amount</th>

                                        <th>Created Date</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    <?php if(!empty($far_order)): ?>

                                    <?php $__currentLoopData = $far_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>

                                        <td><?php echo e(++$key); ?></td>


                                        <td><?php echo e($value->Shop_Name->shop_name); ?></td>

                                        <td><?php echo e($value->farmer_code); ?></td>

                                        <td><?php echo e($value->amount); ?></td>

                                        <td><?php echo e(date('d/m/y', strtotime($value->created_at))); ?></td>

                                        <td class="text-right">

                                            <!-- <a href="<?php echo e(route('farmer_order.view',encrypt($value->id))); ?>"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">View</button></a> -->

                                            <a href="<?php echo e(route('farmer_order.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                            </td>

                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php if($far_order->count() == 0): ?>

                                        <tr class="text-center">

                                            <td colspan="6">No Group to display.</td>

                                        </tr>

                                        <?php endif; ?>

                                    <?php endif; ?>

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Shop Name</th>

                                        <th>Farmer Code</th>

                                        <th>Amount</th>

                                        <th>Created Date</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying <?php echo e($far_order->count()); ?> of <?php echo e($far_order->total()); ?> Groups.</p>

                        </div>

                        <div class="pagination">
                            <ul class="pagination-list">
                                <?php if($far_order->currentPage() > 1): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($far_order->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                    </li>
                                <?php endif; ?>

                                <?php if($far_order->currentPage() > 3): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($far_order->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                    </li>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                <?php endif; ?>

                                <?php $__currentLoopData = range(max(1, $far_order->currentPage() - 2), min($far_order->lastPage(), $far_order->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="pagination-item <?php echo e($page == $far_order->currentPage() ? 'active' : ''); ?>">
                                        <a href="<?php echo e($far_order->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if($far_order->currentPage() < $far_order->lastPage() - 2): ?>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($far_order->appends(request()->all())->url($far_order->lastPage())); ?>" class="pagination-link"><?php echo e($far_order->lastPage()); ?></a>
                                    </li>
                                <?php endif; ?>

                                <?php if($far_order->hasMorePages()): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($far_order->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/agentapp/resources/views/farmer_order/index.blade.php ENDPATH**/ ?>