<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Suggestions</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="<?php echo e(route('/')); ?>" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="<?php echo e(route('user_by_search_suggestion.search')); ?>" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="user_id" type="button" data-toggle="dropdown">
                                    <option value="">Select User</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btn btn-primary" value="Filter">
                            </div>
                        </div>
                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>DATE</th>

                                    <th>MESSAGE</th>



                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                <?php if(!empty($suggestions)): ?>

                                <?php $__currentLoopData = $suggestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td><?php echo e(++$key); ?></td>

                                    <td><?php echo e($value->User->name ?? 'N/A'); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($value->created_at)->format('d-m-Y')); ?></td>

                                    <td><?php echo e($value->suggestion); ?></td>

                                    <td class="text-right">

                                         <a href="<?php echo e(route('suggestion.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($suggestions->count() == 0): ?>

                                    <tr class="text-center">

                                        <td colspan="6">No Suggestion to display.</td>

                                    </tr>

                                    <?php endif; ?>

                                <?php endif; ?>

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Date</th>

                                    <th>Message</th>




                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying <?php echo e($suggestions->count()); ?> of <?php echo e($suggestions->total()); ?> Add suggestion.</p>

                    </div>




                    <div class="pagination">
                        <ul class="pagination-list">
                            <?php if($suggestions->currentPage() > 1): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($suggestions->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                </li>
                            <?php endif; ?>

                            <?php if($suggestions->currentPage() > 3): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($suggestions->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = range(max(1, $suggestions->currentPage() - 2), min($suggestions->lastPage(), $suggestions->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="pagination-item <?php echo e($page == $suggestions->currentPage() ? 'active' : ''); ?>">
                                    <a href="<?php echo e($suggestions->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($suggestions->currentPage() < $suggestions->lastPage() - 2): ?>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="<?php echo e($suggestions->appends(request()->all())->url($suggestions->lastPage())); ?>" class="pagination-link"><?php echo e($suggestions->lastPage()); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($suggestions->hasMorePages()): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($suggestions->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/agentapp/resources/views/suggestion/index.blade.php ENDPATH**/ ?>