<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\{RoleController,AdminController,CompanyServiceController,UserController};
use App\Models\{Country,City,State,Company,Invoice,Currency,AllCurrency,Lead,Source,User,GroupUsers,Group,ServiceInvoice};
use App\Http\Middleware\Authenticate;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/forgetpassword',[CompanyServiceController::class,'ShowForgetPasswordForm'])->name('forget.password.get');
Route::post('forgetpassword',[CompanyServiceController::class,'SubmitForgetPasswordForm'])->name('forget.password.post');

Route::get('resetpassword',[CompanyServiceController::class,'ShowResetPasswordForm'])->name('reset.password.get');
Route::post('resetpassword',[CompanyServiceController::class,'SubmitResetPasswordForm'])->name('reset.password.post');


Route::group(['middleware'=>['auth']],function(){
    Route::get('/index',[AdminController::class,'Dashboard']);

});

Route::get('/', function () {
    if(Auth::check())
    {
        return redirect('/index');
    }
    else
    {
        $companies=Company::get()->first();
        $logo=null;
        if($companies)
        {
          $logo=$companies->logo;
        }
        
        Session::put('logo',$logo);
        return view('frontend.pages-login');
    }
})->name('/');

Route::post('/signed',[AdminController::class,'signIn'])->name('signed');

Route::get('regist', function () {
    return view('frontend.pages-register');
});

Route::group(['middleware' => ['auth']], function() {
   /**
   * Logout Route
   */
   Route::post('/logout',[LoginController::class,'logout']);

});

Route::group(['middleware'=>['auth']],function(){

Route::resource('admin',AdminController::class);

//Roles And Permissions

// Route::post('/add-permission',[AdminController::class,'addPermis']);
// Route::view('forms-permission',"frontend.forms-layouts");

Route::resource('role',RoleController::class);

Route::get('/addroles',[RoleController::class,'index'])->name('addroles');

Route::post('/role-submit',[RoleController::class,'submitRole']);

Route::get('/permissions/{id}',[RoleController::class,'show_permission']);

Route::post('/role-edit/{id}',[RoleController::class,'roleEdit']);

Route::get('/deleterole/{id}',[RoleController::class,'delete_Role']);

Route::get('onchangerole/{id}',[RoleController::class,'ChangeRole']);

Route::get('permis',function(){
    $role=Session::get('roles');
    $roles=Role::all();
    $permissions=Permission::all();
    $rolePermissions = $role->permissions->pluck('id')->toArray();

    $role_permission = Permission::all();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, "."));

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }

        }

    return view('frontend.permis',compact('role','roles','permissions','rolePermissions','custom_permission'));
});


// Users (Agents)
Route::POST('/user/store', [UserController::class,'User_Store'])->name('user.store');

Route::get('/showallAgents',[UserController::class,'AllAgent'])->name('showallAgents');

Route::get('/users-profile',[AdminController::class,'UserProfile'])->name('users-profile');

Route::post('/user-edit/{id}',[UserController::class,'EditUser']);

Route::get('/agent/edit/{id}', [UserController::class, 'edit'])->name('agent.edit');

Route::post('/agent/update/{id}', [UserController::class,'update'])->name('agent.update');

Route::get('/agent/delete/{id}', [UserController::class,'delete'])->name('agent.delete');

Route::get('/agent/view/{id}', [UserController::class,'View'])->name('agent.view');

Route::get('/addnewAgent',[UserController::class,'NewAgent'])->name('addnewAgent');

Route::POST('/Agent/store', [UserController::class,'Agent_Store'])->name('Agent.store');

Route::get('country-state-city', [UserController::class, 'getCountry']);

Route::post('get-states-by-country', [UserController::class, 'getState']);

Route::post('get-cities-by-state', [UserController::class, 'getCity']);

Route::post('get-district-by-state', [UserController::class, 'getDistrict']);

Route::get('/agentactive/{id}', [UserController::class,'Agent_Active'])->name('agentactive');






Route::POST('/login-with-user/{id}',[UserController::class,'UserLogin'])->name('login-with-user');



Route::view('components-view',"frontend.components-view");

Route::get('currency-page',[AdminController::class,'Currencyfun']);
Route::post('storecurrency',[AdminController::class,'SetCurrency']);
Route::post('/addnewcurrency',[AdminController::class,'AddCurrency']);
Route::get('/deletecurrency/{id}',[AdminController::class,'deleteCurrency']);

Auth::routes();

//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::resource('salesorder',CompanyServiceController::class);

Route::post('/searchlead',[AdminController::class,'Search']);

Route::get('/serviceinvoice',[CompanyServiceController::class,'ShowServiceInvoice']);

Route::post('/saveremarklead/{id}',[CompanyServiceController::class,'RemarkSave']);

Route::get('/remarkdelete/{id}',[CompanyServiceController::class,'RemarkDelete']);

Route::post('/editremark/{id}',[CompanyServiceController::class,'EditRemark']);

Route::get('/importfile-pages',[CompanyServiceController::class,'ImportView']);

Route::post('/importdata',[CompanyServiceController::class,'DataImport'])->name('importdata');




 // Add Product start


Route::get('/products', [App\Http\Controllers\AddProductController::class,'index'])->name('products');

Route::get('/addproduct/create', [App\Http\Controllers\AddProductController::class,'create'])->name('addproduct.create');

Route::post('/addproduct/store', [App\Http\Controllers\AddProductController::class,'store'])->name('addproduct.store');

Route::get('/products/edit/{id}', [App\Http\Controllers\AddProductController::class,'edit'])->name('products.edit');

Route::post('/products/update/{id}', [App\Http\Controllers\AddProductController::class,'update'])->name('products.update');

Route::get('/products/delete/{id}', [App\Http\Controllers\AddProductController::class,'delete'])->name('products.delete');

Route::get('/productactive/{id}', [App\Http\Controllers\AddProductController::class,'product_Active'])->name('productactive');


// Brand Master  start

Route::get('/brandmaster', [App\Http\Controllers\BrandMasterController::class,'index'])->name('brandmaster');

Route::get('/brandmaster/create', [App\Http\Controllers\BrandMasterController::class,'create'])->name('brandmaster.create');

Route::post('/brandmaster/store', [App\Http\Controllers\BrandMasterController::class,'store'])->name('brandmaster.store');

Route::get('/brandmaster/edit/{id}', [App\Http\Controllers\BrandMasterController::class,'edit'])->name('brandmaster.edit');

Route::post('/brandmaster/update/{id}', [App\Http\Controllers\BrandMasterController::class,'update'])->name('brandmaster.update');

Route::get('/brandmaster/delete/{id}', [App\Http\Controllers\BrandMasterController::class,'delete'])->name('brandmaster.delete');


// Category Master  start

Route::get('/category', [App\Http\Controllers\CategoryMasterController::class,'index'])->name('category');

Route::get('/category/create', [App\Http\Controllers\CategoryMasterController::class,'create'])->name('category.create');

Route::post('/category/store', [App\Http\Controllers\CategoryMasterController::class,'store'])->name('category.store');

Route::get('/category/edit/{id}', [App\Http\Controllers\CategoryMasterController::class,'edit'])->name('category.edit');

Route::post('/category/update/{id}', [App\Http\Controllers\CategoryMasterController::class,'update'])->name('category.update');

Route::get('/category/delete/{id}', [App\Http\Controllers\CategoryMasterController::class,'delete'])->name('category.delete');



//MemberShip 

Route::get('/Memberships',[App\Http\Controllers\CategoryMasterController::class,'Membership_index'])->name('Memberships');

Route::get('/membership/create', [App\Http\Controllers\CategoryMasterController::class,'Membership_create'])->name('membership.create');

Route::post('/membership/store', [App\Http\Controllers\CategoryMasterController::class,'Membership_store'])->name('membership.store');

Route::get('/membership/edit/{id}', [App\Http\Controllers\CategoryMasterController::class,'Membership_edit'])->name('membership.edit');

Route::post('/membership/update/{id}', [App\Http\Controllers\CategoryMasterController::class,'Membership_update'])->name('membership.update');

Route::get('/membership/delete/{id}', [App\Http\Controllers\CategoryMasterController::class,'Membership_delete'])->name('membership.delete');



// complain  start

Route::get('/complain', [App\Http\Controllers\ComplainController::class,'index'])->name('complain');

Route::get('/complain/delete/{id}', [App\Http\Controllers\ComplainController::class,'delete'])->name('complain.delete');

Route::get('/user_by_search', [App\Http\Controllers\ComplainController::class, 'search'])->name('user_by_search.search');




// Shops routes  start

Route::get('/allShops', [App\Http\Controllers\ShopController::class,'index'])->name('allShops');

Route::get('/addShops', [App\Http\Controllers\ShopController::class,'create'])->name('addShops');

Route::post('/shops/store', [App\Http\Controllers\ShopController::class,'Shops_Store'])->name('shops.store');

Route::post('/customer-edit/{id}', [App\Http\Controllers\ShopController::class,'EditCustomer'])->name('customer-edit');

Route::get('/customer/edit/{id}', [App\Http\Controllers\ShopController::class,'edit'])->name('customer.edit');

Route::get('/shop/view/{id}', [App\Http\Controllers\ShopController::class,'View'])->name('shop.view');

Route::post('/customer/update/{id}', [App\Http\Controllers\ShopController::class,'update'])->name('customer.update');

Route::get('/shop/delete/{id}', [App\Http\Controllers\ShopController::class,'delete'])->name('shop.delete');

Route::get('/shopactive/{id}', [App\Http\Controllers\ShopController::class,'Shop_Active'])->name('shopactive');

Route::get('/order_history_of_shop/{id}' ,[App\Http\Controllers\ShopController::class, 'Order_History'])->name('order_history_of_shop');

Route::get('country-state-city', [App\Http\Controllers\ShopController::class, 'getCountry']);

Route::post('get-states-by-country', [App\Http\Controllers\ShopController::class, 'getState']);

Route::post('get-cities-by-state', [App\Http\Controllers\ShopController::class, 'getCity']);




// Attendence  start

Route::get('/attendence', [App\Http\Controllers\AttendenceController::class,'index'])->name('attendence');

Route::get('/attendence/delete/{id}', [App\Http\Controllers\AttendenceController::class,'delete'])->name('attendence.delete');

Route::get('/employee_by_search_attendence', [App\Http\Controllers\AttendenceController::class,'search'])->name('employee_by_search_attendence.search');



// order  start

Route::get('/orders', [App\Http\Controllers\OrderController::class,'index'])->name('orders');

Route::get('/order/delete/{id}', [App\Http\Controllers\OrderController::class,'delete'])->name('order.delete');

Route::get('/order/view/{id}', [App\Http\Controllers\OrderController::class,'View_details'])->name('order.view');

Route::get('/user_by_search_order', [App\Http\Controllers\OrderController::class, 'search'])->name('user_by_search_order.search');


// Farmer Orders

Route::get('/farmer_orders' ,[App\Http\Controllers\OrderController::class,'Farmer_index'])->name('farmer_orders');

Route::get('/farmer_order/delete/{id}' ,[App\Http\Controllers\OrderController::class,'Farmer_Delete'])->name('farmer_order.delete');

Route::get('/farmer_order/view/{id}' ,[App\Http\Controllers\OrderController::class,'Farmer_View'])->name('farmer_order.view');

Route::get('/farmer_order_filter', [App\Http\Controllers\OrderController::class, 'Farmer_search'])->name('farmer_order_filter');


// Home Setting start

Route::get('/home_setting', [App\Http\Controllers\HomeSettingController::class,'index'])->name('home_setting');

Route::post('/sign-up/slider/update', [App\Http\Controllers\HomeSettingController::class,'signupsliderupdate'])->name('signup.slider.update');

Route::get('/remove/app/sign/{type}', [App\Http\Controllers\HomeSettingController::class,'remove_sign_slider'])->name('remove.app_sign');


// Report

Route::get('/report', [App\Http\Controllers\ReportController::class,'index'])->name('report');

Route::get('/report/delete/{id}', [App\Http\Controllers\ReportController::class,'delete'])->name('report.delete');

Route::get('/employee_by_search', [App\Http\Controllers\ReportController::class, 'search'])->name('employee_by_search.search');


//  Info-Alert start

Route::get('/info_alerts', [App\Http\Controllers\InfoAlertController::class,'index'])->name('info_alerts');

Route::get('/info_alert/create', [App\Http\Controllers\InfoAlertController::class,'create'])->name('info_alert.create');

Route::post('/info_alert/store', [App\Http\Controllers\InfoAlertController::class,'store'])->name('info_alert.store');

Route::get('/info_alert/edit/{id}', [App\Http\Controllers\InfoAlertController::class,'edit'])->name('info_alert.edit');

Route::post('/info_alert/update/{id}', [App\Http\Controllers\InfoAlertController::class,'update'])->name('info_alert.update');

Route::get('/info_alert/delete/{id}', [App\Http\Controllers\InfoAlertController::class,'delete'])->name('info_alert.delete');
Route::get('/info_date', [App\Http\Controllers\InfoAlertController::class,'date'])->name('info_date.date');


// Suggestions  start

Route::get('/suggestions', [App\Http\Controllers\SuggestionController::class,'index'])->name('suggestions');

Route::get('/suggestion/delete/{id}', [App\Http\Controllers\SuggestionController::class,'delete'])->name('suggestion.delete');

Route::get('/user_by_search_suggestion', [App\Http\Controllers\SuggestionController::class, 'search'])->name('user_by_search_suggestion.search');


// Social Url
Route::get('/SocialLinks', [App\Http\Controllers\SuggestionController::class, 'SocialUrl'])->name('SocialLinks');
Route::post('/EditSocialUrl/{id}', [App\Http\Controllers\SuggestionController::class, 'SocialEdit'])->name('EditSocialUrl');


});


