<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Login
Route::post('/login', [App\Http\Controllers\API\ApiController::class,'login']);

//product all show
Route::post('/products', [App\Http\Controllers\API\ApiController::class,'productShow']);

//product id show data
Route::get('/productShowById/{id}', [App\Http\Controllers\API\ApiController::class,'productShowByid']);


//Category all show
Route::post('/category', [App\Http\Controllers\API\ApiController::class,'Category_Show']);

//show all Membership 
Route::get('/allMembership',[App\Http\Controllers\API\ApiController::class,'Membership_Show']);

//Home Banner all show
Route::get('/home_banner', [App\Http\Controllers\API\ApiController::class,'HomeBanner_Show']);

//Shops Store 
Route::post('/ShopsSave',[App\Http\Controllers\API\ApiController::class,'ShopSave']);

// Show All Shops
Route::post('/allShops',[App\Http\Controllers\API\ApiController::class,'ShowShop']);

//Farmer Store 
Route::post('/FarmersSave',[App\Http\Controllers\API\ApiController::class,'FarmerSave']);

// Show All Farmers
Route::post('/allFarmers',[App\Http\Controllers\API\ApiController::class,'ShowFarmers']);

//Complain Store
Route::post('/complainStore', [App\Http\Controllers\API\ApiController::class,'Complain_Store']);

//Complain Show by User_id
Route::post('/complainbyuser', [App\Http\Controllers\API\ApiController::class,'Complain_Show']);

//Suggestion Store
Route::post('/suggestionStore', [App\Http\Controllers\API\ApiController::class,'Suggestion_Store']);

//Suggestion Show by User_id
Route::post('/suggestion_by_user', [App\Http\Controllers\API\ApiController::class,'Suggestion_Show']);

//Suggestion delete
Route::post('/suggestion_delete', [App\Http\Controllers\API\ApiController::class,'Suggestion_Delete']);

//Attendence Store
Route::post('/attendenceStore', [App\Http\Controllers\API\ApiController::class,'Attendence_Store']);

//Attendence Updated
Route::post('/attendenceModify', [App\Http\Controllers\API\ApiController::class,'Attendence_Update']);

//Attendence Show by User_id
Route::get('/attendencebyuser/{id}', [App\Http\Controllers\API\ApiController::class,'Attendence_Show']);

//Attendence Show by Day
Route::post('/attendenceday', [App\Http\Controllers\API\ApiController::class,'Attendence_Day']);

//leave Store
Route::post('/leave_store', [App\Http\Controllers\API\ApiController::class,'Leave_Store']);


// Country List
Route::get('/countryList', [App\Http\Controllers\API\ApiController::class,'Country_List']);

// state list by Country
Route::get('/State_list_by_country/{id}', [App\Http\Controllers\API\ApiController::class,'State_List']);

// District List By state
Route::get('/District_list_by_state/{id}', [App\Http\Controllers\API\ApiController::class,'District_List']);


//Report Store
Route::post('/report-store', [App\Http\Controllers\API\ApiController::class,'Report_Save']);

//Report Show by User_id
Route::post('/reportbyuser', [App\Http\Controllers\API\ApiController::class,'Report_Show']);

//Report Show by Day
Route::post('/reportday', [App\Http\Controllers\API\ApiController::class,'Report_Day']);

//order Store
Route::post('/order-store', [App\Http\Controllers\API\ApiController::class,'Order_Save']);

//Order Show by User_id
Route::post('/orderbyuser', [App\Http\Controllers\API\ApiController::class,'Order_Show']);

// Order History order_id wise
Route::get('/order-history/{order_id}',[App\Http\Controllers\API\ApiController::class,'Order_History_Show']);

// farmer_order
Route::post('/farmer_Order_Store', [App\Http\Controllers\API\ApiController::class, 'FarmerOrderStore']);

// farmer Order View
Route::post('/farmer_Order_View', [App\Http\Controllers\API\ApiController::class, 'FarmerOrderView']);

// Social Links
Route::get('/SocialLinks' ,[App\Http\Controllers\API\ApiController::class, 'SocialUrl']);














