@extends('frontend.layouts.main')
@section('main-container')
  <main id="main" class="main">
    <div class="pagetitle">
      <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h3>Shops</h3>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

             <a href="{{url('/allShops')}}" class="btn btn-rounded bg-grad-4 ml-4">

                <span class="btn-icon-left" style="color: white">Back</span>

            </a>

        </div>

    </div>
    </div><!-- End Page Title -->
    <section class="section dashboard">
      <div class="row" style="margin-top: 25px">

        <!-- Left side columns -->
        <div class="col-lg-3">
            <!-- Sales Card -->
            <div class="card info-card sales-card">

                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="text-align-center">
                            @if ($users->profile == null)
                                <div class="rounded-circle border d-flex justify-content-center align-items-center"
                                    style="width: 60px; height: 60px; margin-top: 15px; margin-bottom: 10px;">
                                    <i class="bi bi-person-circle" style="font-size: 60px;"></i>
                                </div>
                            @else
                            <img src="{{ url('public/Image/' . $users->profile) }}" alt="avatar1"
                            class="rounded-circle" style="height: 60px; width: 60px; margin-top: 15px; margin-bottom: 10px;">
                            @endif
                            <p><strong>Name: </strong> {{ $users->name }}</p>
                            <p><strong>Mobile: </strong> {{ $users->mobile }}</p>
                            <span class="text-success small pt-1 fw-bold"></span>
                            <span class="text-muted small pt-2 ps-1"></span>
                        </div>
                    </div>
                </div>

            </div>
        </div><!-- End Sales Card -->

        <!-- End Left side columns -->

        <div class="col-lg-9">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title">About<span></span></h5>
                <table class="table">
                  <tbody>
                      <tr>
                          <td><strong>Shop Name: </strong>{{$users->shop_name}} </td>
                          <td><strong>Email: </strong> {{$users->email}}</td>
                      </tr>
                      <tr>
                          <td><strong>Registered By: </strong> @if($users->registered_by!=null) {{$users->User_name->name}} @endif</td>
                          <td><strong>Code: </strong> {{$users->code}}   </td>
                      </tr>
                      
                      <tr>
                          <td><strong>State: </strong> @if($users->state!=null){{$users->State->state_name}} @endif </td>
                          <td><strong>District: </strong> @if($users->district!=null) {{$users->District->dist_name}} @endif </td>
                      </tr>
                      <tr>
                          <td><strong>City: </strong>  {{$users->city}} </td>
                          <td><strong>Address: </strong>  {{$users->address}} </td>

                      </tr>
                  </tbody>
              </table>


              </div>
            </div>

          </div><!-- End Right side columns -->


      </div>
      <div class="tab">
       <span> <button class="tablinks btn btn-warning" onclick="openCity(event, 'London')">Order</button> &nbsp; &nbsp; <button class="tablinks btn btn-warning" onclick="openCity(event, 'india')">Farmer Order</button></span>
      </div>

      <div id="London" class="tabcontent">
        <h3>Shop Order</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Date</strong></td>
              <td><strong>Amount</strong></td>
              <td><strong>Action</strong></td>
            </thead>

            <tbody>
                @foreach($orders as $key=>$value)
              <tr>
                <td>{{ ++$key }}</td>
                <td>{{ $value->User->name ?? 'No User' }}</td>
                 <td>{{ date('d/m/y', strtotime($value->created_at));}}</td>
                 <td>₹ {{ $value->amount }} /-</td>
                 <td><a href="{{route('order_history_of_shop',$value->id)}}" class="btn btn-warning rounded-pill btn-sm">Order History</a> </td>
              </tr>
              @endforeach
            </tbody>

          </table>
          
      </div>

      <script>
        function openCity(evt, cityName) {
          var i, tabcontent, tablinks;
          tabcontent = document.getElementsByClassName("tabcontent");
          for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
          }
          tablinks = document.getElementsByClassName("tablinks");
          for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
          }
          document.getElementById(cityName).style.display = "block";
          evt.currentTarget.className += " active";
        }
    </script>

    

      <div id="india" class="tabcontent">
        <h3>Farmer Order</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Farmer Code</strong></td>
              <td><strong>Amount</strong></td>
            </thead>

            <tbody>
                @foreach($farmer_order as $key=>$value)
              <tr>
                <td>{{ ++$key }}</td>
                <td>{{ $value->User->name ?? 'No User' }}</td>
                 <td>{{ date('d/m/y', strtotime($users->created_at));}}</td>
                 <td>₹ {{ $value->amount }} /-</td>
              </tr>
              @endforeach
            </tbody>

          </table>
      </div>


      
     

    </section>

  </main><!-- End #main -->

 @endsection


