@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')
<style type="text/css">
         .flex-1{
            display: none;
       }
     .w-5{
      display: none;
     }   
    </style>
<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Products</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{url('addproduct/create')}}">

            <button type="button" class="btn rounded-pill  bg-grad-4 ml-4">

                <span class="btn-icon-left" style="color: white">
                + Add Product
                </span>
               

            </button>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form method="GET" action="">

                        <div class="row text-right">

                            <div class="col-md-6"></div>

                            <div class="col-md-4">

                                 <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by Products Name">

                            </div>

                             <div class="col-md-2">

                                <label class="">&nbsp;</label>

                                <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                            </div>

                        </div>

                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border" >

                            <thead>

                                <tr>

                                

                                    <th>PRODUCT NAME</th>

                                    <th>IMAGE</th>

                                    <th>CATEGORY</th>

                                    <th>UNIT</th>

                                    <th>PRICE</th>

                                    <th>DISCOUNT</th>

                                    <th>STATUS</th>

                                    <th class="">ACTION</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($add_products))

                                @foreach($add_products as $key=>$value)

                                <tr>

                                   

                                    <td>{{ $value->name }}</td>

                                    <td>
                                        @if($value->image)
                                        <img src="{{ url('/uploads/product/'.$value->image) }}" height="50" width="50">
                                        @endif
                                    </td>

                                    

                                    <td>
                                        @if($value->category!=Null){{ $value->Category->name }}@endif
                                    </td>

                                    <td>{{ $value->unit }}</td>

                                    <td>₹ {{ $value->product_price }} /-</td>

                                    <td>{{$value->discount}}</td>

                                    <td>
                                        @if($value->status=='1')

                                            <a href="{{url('productactive/'.$value->id)}}">

                                                <button class="btn btn-success rounded-pill btn-sm">Active</button>

                                            </a>
                                            @else
                                            <a href="{{url('productactive/'.$value->id)}}">

                                                <button class="btn btn-danger rounded-pill btn-sm">InActive</button>

                                            </a>

                                            @endif
                                    </td>

                                    <td class="">

                                        <a href="{{ route('products.edit',encrypt($value->id)) }}"  ><i class="bi bi-pencil-square" style="color:black;"></i></a>

                                        <a href="{{ route('products.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')" ><i class="bi bi-trash-fill" style="color:red;"></i></a>

                                    </td>

                                    </tr>

                                @endforeach

                                    @if ($add_products->count() == 0)

                                    <tr class="text-center">

                                        <td colspan="8">No Product to display.</td>

                                    </tr>

                                    @endif

                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    

                                    <th>PRODUCT NAME</th>

                                    <th>IMAGE</th>

                                    <th>CATEGORY</th>

                                    <th>UNIT</th>

                                    <th>PRICE</th>

                                    <th>DISCOUNT</th>

                                    <th>STATUS</th>

                                    <th class="">ACTION</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>
                   

                </div>

            </div>

{{ $add_products->links() }}

        </div>

    </div>

</div>
</main><!-- End #main -->
 @endsection
