@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Add Product</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('products')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">
                Back
            </span>

        </a>

    </div>

</div>

<div class="content-wrapper" style="margin-top: 15px">
        <div class="row ">
          <div class="card">
            <div class="card-body">

              <form action="{{route('addproduct.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="form-group col-lg-6">

                        <label> Product Name <span class="text-danger">*</span></label>

                        <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Name" required>

                         @error('name'){{ $message }}@enderror 

                    </div>

                    <div class="form-group col-lg-6">
                        <label>Category <span class="text-danger"></span></label>
                         <select class=" form-control custom-select" name="category" data-toggle="dropdown">
                            <option value="">Select Category</option>
                             @foreach($category as $cat)
                             <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                             @endforeach
                        </select>
                        <span class="text-danger">@error('category'){{ $message }}@enderror</span>
                    </div>

                    
                    <div class="form-group col-lg-6">

                        <label>Unit <span class="text-danger"></span></label>

                         <select class=" form-control custom-select" name="unit" data-toggle="dropdown">
                            <option value="">Select Unit</option>
                            <option value="KG">KG</option>
                            <option value="GM">GM</option>
                            <option value="LTR">LTR</option>
                            <option value="ML">ML</option>
                            <option value="PCS">PCS</option>
                        </select>

                        <span class="text-danger"> @error('unit'){{ $message }}@enderror </span>

                    </div>

                    <div class="form-group col-lg-6">

                        <label>MRP <span class="text-danger">*</span></label>

                        <input type="text" class="form-control" name="product_price" value="{{old('product_price')}}" placeholder="Enter MRP" required>

                        @error('product_price'){{ $message }}@enderror 

                    </div>

                    <div class="form-group col-lg-6">

                        <label>GST(%) <span class="text-danger"></span></label>

                        <input type="text" class="form-control" name="GST" value="{{old('GST')}}" placeholder="Gst Value in %">

                        <span class="text-danger"> @error('GST'){{ $message }}@enderror </span>

                    </div> 

                    <div class="form-group col-lg-6">

                        <label>Discount(%)<span class="text-danger"></span></label>

                        <input type="text" class="form-control" name="discount" value="{{old('discount')}}" placeholder="Enter Discount Amount In %">

                        <span class="text-danger"> @error('discount'){{ $message }}@enderror </span>

                    </div>

                    <div class="form-group col-lg-6">

                        <label>Stock quatity<span class="text-danger"></span></label>

                        <input type="text" class="form-control" name="stock_qty" value="{{old('stock_qty')}}" placeholder="Enter Stock Quatity">

                        <span class="text-danger"> @error('stock_qty'){{ $message }}@enderror </span>

                    </div>


                    <div class="form-group col-lg-6">

                        <label>Agent Commission(%)<span class="text-danger"></span></label>

                        <input type="text" class="form-control" name="agent_commission" value="{{old('agent_commission')}}" placeholder="Agent Commission">

                        <span class="text-danger"> @error('agent_commission'){{ $message }}@enderror </span>

                    </div>

                    <div class="form-group col-lg-6">

                        <label>Image <span class="text-danger">*</span></label>

                        <input type="file" class="form-control" name="image" id="image" required>

                        <img id="preview-image-before-upload" height="100" class="mt-2">

                        <span class="text-danger"> @error('image'){{ $message }}@enderror </span>

                    </div>

                    <div class="form-group col-lg-6">

                        <label>Offer Title <span class="text-danger"></span></label>

                        <input type="text" class="form-control" name="offer_title" placeholder="Enter Offer Title">

                        <span class="text-danger"> @error('offer_title'){{ $message }}@enderror </span>

                    </div>

                    <div class="form-group col-lg-6">

                        <label>Offer Image <span class="text-danger"></span></label>

                        <input type="file" class="form-control" name="offer_image" id="image">

                        <span class="text-danger"> @error('offer_image'){{ $message }}@enderror </span>

                    </div>


                    <div class="form-group col-lg-12">
                        <label>Description <span class="text-danger"></span></label>
                      
                            <textarea type="number" class="form-control ckeditor" name="description" value="{{old('description')}}" placeholder="Description" ></textarea>
                        
                        <span class="text-danger"> @error('description'){{ $message }}@enderror </span>
                    </div>

                    <div class="form-group col-lg-12">

                                <label>Product Features <span class="text-danger"></span></label>

                                <textarea class="form-control ckeditor" name="product_features" placeholder="Enter Message"></textarea>

                                <span class="text-danger"> @error('product_features'){{ $message }}@enderror </span>

                    </div>

                

                </div>

                <div class="text-center">
                    <button type="submit" class="btn btn-primary bg-grad-4">Submit</button>
                </div>

              </form>

            </div>
          </div>
        </div>
      </div>


</main><!-- End #main -->
 @endsection

 <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
 <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

 <script type="text/javascript">

 $(document).ready(function (e) {

    $('#preview-image-before-upload').hide();

    $('#image').change(function(){

     $('#preview-image-before-upload').show();

     let reader = new FileReader();

     reader.onload = (e) => {

       $('#preview-image-before-upload').attr('src', e.target.result);
     }

     reader.readAsDataURL(this.files[0]);

    });

 });

 </script>




