@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">MemberShips</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="{{ route('membership.create') }}">

                    <button type="button" class="btn btn-primary rounded-pill bg-grad-4 ml-4">

                        <span class="btn-icon-left" style="color: white">
                        + Add Membership
                       </span>
                       

                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        @include('flash_msg')

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form method="GET" action="">

                            <div class="row text-right">

                                <div class="col-md-6"></div>

                                <div class="col-md-4">

                                    <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by Membership Name">

                                </div>

                                <div class="col-md-2">

                                    <label class="">&nbsp;</label>

                                    <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                                </div>

                            </div>

                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Name</th>

                                        <th>Image</th>


                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    @if(!empty($membership))

                                    @foreach($membership as $key=>$value)

                                    <tr>

                                        <td>{{ ++$key }}</td>


                                        <td>{{ $value->title }}</td>

                                        <td>
                                            <img src="{{ url('/uploads/membership/'.$value->image) }}" class="avatar1" style="height:40px; width:50px;">
                                        </td>

                                        <td class="text-right">

                                            <a href="{{ route('membership.edit',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                            <a href="{{ route('membership.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                            </td>

                                        </tr>

                                    @endforeach

                                        @if ($membership->count() == 0)

                                        <tr class="text-center">

                                            <td colspan="6">No Membership to display.</td>

                                        </tr>

                                        @endif

                                    @endif

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Name</th>

                                        <th>Image</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                       


                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 @endsection
