@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Memberships</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('Memberships')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">
                Back
            </span>

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                        <form action="{{route('membership.update',$membership->id)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">


                            <div class="form-group col-lg-6">
                              <label>Name<span class="text-danger">*</span></label>
                              <input type="text" class="form-control" name="title" value="{{$membership->title}}" placeholder="Enter Your Membership Name" required>
                              <span class="text-danger"> @error('title'){{ $message }}@enderror </span>
                            </div>

                            <div class="form-group col-lg-6">
                              <label>Image<span class="text-danger">*</span></label>
                              <input type="file" class="form-control" name="image" value="{{$membership->image}}" >
                              <span class="text-danger"> @error('image'){{ $message }}@enderror </span>
                            </div>

                            <div class="form-group col-lg-12">

                                <label>Description <span class="text-danger"></span></label>

                                <textarea class="form-control ckeditor" name="description" placeholder="Enter Message"></textarea>

                                <span class="text-danger"> @error('description'){{ $message }}@enderror </span>

                            </div>

                            <div class="text-center">

                               <button type="submit" class="btn btn-success">Submit</button>

                            </div>


                        </div>

                       

                    </form>

                </div>

            </div>

        </div>

    </div>

      </div>
</main><!-- End #main -->
 @endsection


