@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Memberships</h3>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('Memberships')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">
                Back
            </span>

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('membership.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="title" value="{{old('title')}}" placeholder="Enter Your Membership Name" required>
                                  <span class="text-danger"> @error('title'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                  <label>Image<span class="text-danger">*</span></label>
                                  <input type="file" class="form-control" name="image" value="{{old('image')}}" required>
                                  <span class="text-danger"> @error('image'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-12">

                                    <label>Description <span class="text-danger"></span></label>

                                    <textarea class="form-control ckeditor" name="description" placeholder="Enter Message"></textarea>

                                    <span class="text-danger"> @error('description'){{ $message }}@enderror </span>

                                </div>

                                <div class="text-center">
                                    <button type="submit"  class="btn btn-primary" style="margin-right:7px;">Submit</button>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>

<script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>

 @endsection

 {{-- <script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var country_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"{{url('get-states-by-country')}}",
    type: "POST",
    data: {
    country_id: country_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $.each(result.states,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    $('#city-dropdown').html('<option value="">Select State First</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var state_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"{{url('get-cities-by-state')}}",
    type: "POST",
    data: {
    state_id: state_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $.each(result.cities,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
    });
    }
    });
    });
    });
    </script> --}}

    <script>
        $(document).ready(function() {
            $('#state-dropdown').on('change', function() {
                var state_id = this.value;
                $("#city-dropdown").html('');
                $.ajax({
                    url:"{{url('get-cities-by-state')}}",
                    type: "POST",
                    data: {
                        state_id: state_id,
                        _token: '{{csrf_token()}}'
                    },
                    dataType : 'json',
                    success: function(result) {
                        $.each(result.cities, function(key, value) {
                            $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                        });
                    }
                });
            });
        });
    </script>



