@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">Information Alert</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="{{url('info_alert/create')}}">

                    <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                        <span class="btn-icon-left" style="color: white">+ Add Information Alert</span>
                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        @include('flash_msg')

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form action="{{ route('info_date.date') }}" method="get">
                            <div class="row">
                               <div class="col-md-5 form-group">
                                   <label for="">Date From</label>
                                   <input type="date" name="date_from" class="form-control" value="{{ $request->date_from }}">
                                </div>
                                <div class="col-md-5 form-group">
                                   <label for="">Date From</label>
                                   <input type="date" name="date_to" class="form-control" value="{{ $request->date_to }}">
                                </div>
                                <div class="col-md-2 form-group" style="margin-top:30px;">
                                   <input type="submit" class="btn btn-primary" value="Search">
                                </div>
                            </div>
                       </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>DATE</th>

                                        <th>MESSAGE</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    @if(!empty($info_alerts))

                                    @foreach($info_alerts as $key=>$value)

                                    <tr>

                                        <td>{{ ++$key }}</td>

                                        <td>{{ \Carbon\Carbon::parse($value->created_at)->format('d-m-Y') }}</td>


                                        <td>{{ strip_tags($value->message) }}</td>

                                        <td class="text-right">

                                            <a href="{{ route('info_alert.edit',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                            <a href="{{ route('info_alert.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                            </td>

                                        </tr>

                                    @endforeach

                                        @if ($info_alerts->count() == 0)

                                        <tr class="text-center">

                                            <td colspan="6">No Information Alerts to display.</td>

                                        </tr>

                                        @endif

                                    @endif

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Date</th>

                                        <th>Message</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying {{$info_alerts->count()}} of {{ $info_alerts->total() }}info_alerts.</p>

                        </div>

                         <div class="pagination">
                            <ul class="pagination-list">
                                @if ($info_alerts->currentPage() > 1)
                                    <li class="pagination-item">
                                        <a href="{{ $info_alerts->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                    </li>
                                @endif

                                @if ($info_alerts->currentPage() > 3)
                                    <li class="pagination-item">
                                        <a href="{{ $info_alerts->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                    </li>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                @endif

                                @foreach(range(max(1, $info_alerts->currentPage() - 2), min($info_alerts->lastPage(), $info_alerts->currentPage() + 2)) as $page)
                                    <li class="pagination-item {{ $page == $info_alerts->currentPage() ? 'active' : '' }}">
                                        <a href="{{ $info_alerts->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                    </li>
                                @endforeach

                                @if ($info_alerts->currentPage() < $info_alerts->lastPage() - 2)
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                    <li class="pagination-item">
                                        <a href="{{ $info_alerts->appends(request()->all())->url($info_alerts->lastPage()) }}" class="pagination-link">{{ $info_alerts->lastPage() }}</a>
                                    </li>
                                @endif

                                @if ($info_alerts->hasMorePages())
                                    <li class="pagination-item">
                                        <a href="{{ $info_alerts->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                    </li>
                                @endif
                            </ul>
                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 @endsection
