@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
 <div style="margin-top:15px ;">
    <h4 class="text-uppercase mb-3">Paid Lead Details</h4>
 </div>
     <table class="table table-striped display nowrap" id="tabl">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Assign To</th>
                        <th>Action</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                <tbody> 
                 @foreach($leads as $key=>$value)
                  <tr>
                    <td>{{++$key}}</td>
                    <td>{{$value->name}}</td>
                    <td>{{$value->phone}}</td>   
                    <td>@if($value->assigned!=0){{$value->assign->name}}@endif</td>             
                    <td>    
                       <a href="{{url('/leadmoreview/'.$value->id)}}" ><button type="button" class="btn "><i class="bi  bi-eye" style="color:blue;"></i></button></a>

                       <a class="btn " role="button" data-toggle="modal" data-target="#assignlead-{{ $value}}"><i class="bi bi-send-fill" style="color:blue;"></i></a>
                       
                        <!-- Modal -->
                        <div class="modal fade" id="assignlead-{{$value}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="editModalLabel">Assign Lead</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                           <form action="{{url('/multipleassign')}}" method="post">
                            {{ csrf_field() }}
                          <div class="modal-body">
                            <div class="row mb-3">
                              <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                              <div class="col-sm-7">
                              <input type="text" name="lead" value="{{$value->id}}" hidden>
                               <select name="assigned" class="form-control custom-select" style="text-transform:capitalize;">
                                   <option value="">Select Group Manager</option>
                                   @foreach($group_manager as $group)
                                   <option value="{{$group->group_manager}}">{{$group->UserName->name}}</option>
                                   @endforeach
                               </select>
                              </div>          
                            </div>  
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Edit</button>
                          </div>
                        </form>
                        </div>
                        </div>
                        </div> 
                    </td>
                    <td>
                    
                     <a role="button" data-toggle="modal" data-target="#remarklead-{{ $value }}"><button class="btn btn-warning rounded-pill">Remark</button></a>

                            <!-- Modal -->
                            <div class="modal fade" id="remarklead-{{ $value }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel" >Add Remark</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <form action="{{url('saveremarklead/'.$value->id)}}" method="post">
                                {{ csrf_field() }}
                              <div class="modal-body" style="background-color:#F3F2EE ;">
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Follow Up<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   &ensp; &ensp;&ensp;<input class="form-check-input" type="checkbox" name="followup_type[]" id="inlineCheckbox1" value="Email" >&nbsp;Email &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Call" id="inlineCheckbox1">&nbsp; Call 
                                   &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Message" id="inlineCheckbox1">&nbsp; Message
                                  </div>          
                                </div>
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Remark<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   <textarea type="text" name="description" class="form-control" placeholder="Type Here.." required></textarea>
                                  </div>  
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>  
                 
                    </td>
                  </tr>
                @endforeach
                </tbody>
      </table>      
</main>
<script type="text/javascript">  
   $(document).ready(function () {
    $('#tabl').DataTable({
       order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5] } ],
      bFilter: false, 
      bInfo: false
    });
}); 
</script> 
@endsection
