@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
  <div style="margin-top:13px ;">
    <h4 class="text-uppercase mb-3">Contact Lead Details</h4>
  </div>
  @if(Session::has('success'))
    <div id="successMessage" class="alert alert-success">
        {{ Session::get('success') }}
    </div>
  @endif
  <div class="mb-2">
   <form action="{{route('pool-assign')}}" method="post">
    @csrf
   <input type="submit" name="contact_pool" value="Contact Pool" class="btn btn-warning rounded-pill">
  </form>
  </div>
  <form action="{{url('/multipleassign')}}" method="post">   
    @csrf
  <div class="row">
  <div class="mb-1">
  @if(Auth::user()->role=="Admin")  
    <a class="btn btn-warning rounded-pill" role="button" data-toggle="modal" data-target="#assignLeadToManager{{ $group_manager }}"><i class="bi bi-send-fill">Assign To Manager</i></a>

                
                            <!-- Modal -->
                        <div class="modal fade" id="assignLeadToManager{{ $group_manager }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                          <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel">Assign Lead To Group Manager</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                               
                              <div class="modal-body">
                                <div class="row mb-3">
                                  <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id1" class="form-control custom-select" style="text-transform:capitalize;">
                                    <option value="0">Select Group Manager</option>
                                    @if($group_manager)
                                    @foreach($group_manager as $group)
                                    <option value="{{$group->group_manager}}">{{$group->UserName->name}}</option>
                                    @endforeach
                                    @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>

                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" name="manager_form" value="Assign" class="btn btn-primary">
                                <!-- <button type="submit" class="btn btn-primary">Assign</button> -->
                              </div>
                            </div>
                          </div>
                        </div>         

    <a class="btn btn-warning rounded-pill" role="button" data-toggle="modal" data-target="#assignLeadToUser{{ $users }}"><i class="bi bi-send-fill"></i>Assign To User</a>

           <!-- Modal -->
                        <div class="modal fade" id="assignLeadToUser{{ $users }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                         <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel">Assign Lead To User</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"> 
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id2" class="form-control custom-select" style="text-transform:capitalize;">
                                      <option value="0">Select Users</option>
                                      @if($users)
                                      @foreach($users as $user)
                                      @if($user->id==Auth::user()->id)
                                      @else
                                      <option value="{{$user->id}}">{{$user->name}}</option>
                                      @endif
                                      @endforeach
                                      @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" name="user_form" value="Assign" class="btn btn-primary">
                                <!-- <button type="submit" class="btn btn-primary">Assign</button> -->
                              </div>
                          </div>
                         </div>
                        </div> 

  @endif
  @if(($g_manager!=null) )  
    <a  class="btn btn-warning rounded-pill" role="button"  data-toggle="modal" data-target="#assignLeadToGroupUser{{ $group_user }}"><i class="bi bi-send-fill"></i>Assign To Group User</a>

                <!-- Modal -->
                        <div class="modal fade" id="assignLeadToGroupUser{{ $group_user }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                         <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel">Assign Lead To Group User</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id3" class="form-control custom-select" style="text-transform:capitalize;">
                                      <option value="0">Select Group Users</option>
                                      @if($group_user)
                                      @foreach($group_user as $user)
                                      <option value="{{$user->user_id}}">{{$user->UserName->name}}</option>
                                      @endforeach
                                      @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Assign</button>
                              </div>
                          </div>
                         </div>
                        </div>         
                              
  @endif

            <a class="btn btn-warning rounded-pill" role="button" data-toggle="modal" data-target="#disposeLead">Dispose Lead</a>

           <!-- Modal -->
                        <div class="modal fade" id="disposeLead" tabindex="-1" role="dialog" aria-labelledby="disposeModalLabel" aria-hidden="true">
                         <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="disposeModalLabel">Dispose Lead</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"> 
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                  <strong><span><input type="hidden" name="l_pool" value="ContactPool">&nbsp;
                                  <label for="inputText" class="col-form-label">Do you want to add lead to Dispose Pool of Contact</label></span></strong>     
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" name="pool_form" value="Dispose" class="btn btn-primary">
                                <!-- <button type="submit" class="btn btn-primary">Assign</button> -->
                              </div>
                          </div>
                         </div>
                        </div>
  </div>
 </div>
 
                           

                        
      <table class="table table-striped display nowrap" id="tabl" style="width:100%;">
                <thead>
                    <tr>
                        <th></th>
                        <th></th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Assign To</th>
                        <th>Created By</th>
                        <th>Source</th>
                        <th>Status</th>
                        <th>Remark</th>
                        <th>Action</th>

                    </tr>
                </thead>
                <tbody> 
                 @foreach($leads as $key=>$value)
                  <tr>
                    <td></td>
                    <td><input type="checkbox" name="assign_lead_id[]" class="form-check-inline" value="{{$value->id}}"></td></form>
                    <td>{{$value->name}}</td>
                    <td>{{$value->phone}}</td>    
                    <td>@if($value->assigned!=0){{$value->assign->name}}@endif</td>  
                    <td>{{$value->createdby->name}}</td> 
                    <td>@if($value->l_source==null) @else {{$value->source->name}} @endif</td>               
                     

                    <td>     
                       <a class="btn btn-warning rounded-pill" role="button" data-toggle="modal" data-target="#statuslead{{ $key }}">Paid</a>
                    </td>
                            <!-- Modal -->
                            <div class="modal fade" id="statuslead{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="statusModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="statusModalLabel" >Lead Status</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div> 
                              <form action="{{url('changestatus/'.$value->id)}}" method="post">
                              {{ csrf_field() }}  
                              <div class="modal-body">
                                <div class="row mb-3">
                                  <h5 for="inputText">Do you want to change Lead status to Paid</h5>
                                  <input type="text" name="status" value="2" hidden>    
                                </div>
                              </div>
                              <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                              <button type="submit" class="btn btn-primary">Ok</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>  
                       
                      <td>
                          @if($value->assigned==Auth::user()->id or $value->created_by==Auth::user()->id) 
                         <a class="btn btn-success rounded-pill" role="button" data-toggle="modal" data-target="#remarklead{{ $key }}" >+</a>
                         @else
                         <a class="btn btn-danger rounded-pill pt-1 pb-1">x</a>
                         @endif
                         <a class="btn btn-primary rounded-pill" role="button" data-toggle="modal" data-target="#remarkshow{{ $key }}"><i class="bi bi-eye-fill"></i></a>
                      </td>
 
                       
                            <!-- Modal for add remark-->
                            <div class="modal fade" id="remarklead{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="remarkModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="remarkModalLabel" >Add Remark</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <form action="{{url('saveremarklead/'.$value->id)}}" method="post">
                                {{ csrf_field() }}
                              <div class="modal-body" style="background-color:#F3F2EE ;">
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Follow Up<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   &ensp; &ensp;&ensp;<input class="form-check-input" type="checkbox" name="followup_type[]" id="inlineCheckbox1" value="Email" >&nbsp;Email &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Call" id="inlineCheckbox1">&nbsp; Call 
                                   &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Message" id="inlineCheckbox1">&nbsp; Message
                                  </div>          
                                </div>
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Remark<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   <textarea type="text" name="description" class="form-control" placeholder="Type Here.." required></textarea>
                                  </div>  
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div> 
                      

                        <!-- Modal for show remark -->
                        <div class="modal fade" id="remarkshow{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="showremarkModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                        <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="showremarkModalLabel"> Remarks Lists</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <div class="modal-body" style="background-color:#EFEDE7;">
                                @if(count($value->remark)==0)
                                <div class="row mb-2">
                                  <div class="col-md-6">
                                   <strong>Remark Not Found</strong>
                                  </div>       
                                </div>
                                @else
                                @foreach($value->remark as $remark)
                                <div class="row mb-2" >
                                <div class="row mb-1 mt-1">
                                  <div class="col-md-5">
                                    <strong>Date:</strong>&ensp;{{$remark->created_at->format('d/m/Y')}}
                                  </div>
                                  <div class="col-md-7">
                                    <span><strong>Follow Up:&nbsp;</strong></span>
                                     @foreach($remark->followup_type as $arr)
                                     <span style="padding: 1px; background-color: #FBBE3F;">{{$arr}}&nbsp;</span>
                                     @endforeach
                                  </div>
                                 </div>
                                  <div class="row mb-1">       
                                     <span><strong>Remark:</strong>&ensp;<span style="text-transform:capitalize;">{{$remark->description}}</span></span> 
                                  </div>
                                </div>
                                 @endforeach
                                 @endif
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                              </div>    
                        </div>
                        </div>
                        </div>

                    <td>    
                      <a href="{{url('/leadmoreview/'.$value->id)}}" ><i class="bi bi-eye" style="color:blue;"></i></a>

                      <!-- <a  role="button" data-toggle="modal" data-target="#poollead{{ $key }}"><button class="btn btn-info rounded-pill">Contact Pool</button></a> -->

                    </td>

                        <!-- Modal for pool lead-->
                        <div class="modal fade" id="poollead{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="poolModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="poolModalLabel">Contact Lead Pool</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div> 
                          <form  action="{{url('/disposelead/'.$value->id)}}" method="POST">
                           @csrf
                          <div class="modal-body">
                           <div class="row mb-3">
                            <h5>Do you want to add lead to Dispose Pool of Contact Lead</h5>
                            
                              <input type="hidden" name="l_pool" value="ContactPool">    
                            </div>
                          </div>
                          <div class="modal-footer">
                          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                          <button type="submit" class="btn btn-primary" >Ok</button>
                          </div>
                        </form>
                        </div>
                        </div>
                        </div>  
                   
                  </tr>
                @endforeach
                </tbody>
      </table>
</main>
<script type="text/javascript">  
   $(document).ready(function () {
     var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5,6,7,8,9] } ],
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
}); 
</script>
 <script type="text/javascript">
   $('#close-modal').click(function () {
       document.location.reload();
   });
  </script>
  <script type="text/javascript">
   $('#refresh-modal').click(function () {
       document.location.reload();
   });
  </script>
  <script type="text/javascript">
   $('#fresh-modal').click(function () {
       document.location.reload();
   });
  </script>
  <script>
    setTimeout(function() {
        document.getElementById('successMessage').style.display = 'none';
    }, 3000); // 5000 milliseconds = 5 seconds
</script>

@endsection
