@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
    @include('cdn')
     <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<div>
  <a href="{{url()->previous()}}" type="button"  class="btn btn-link "><i class="bi bi-arrow-return-left"></i>back</a>
  @if(Auth::user()->role=='Admin' or Auth::user()->role=='HR')
  <button type="button" onclick="printPageArea('print')" class="btn btn-link float-right"><i class="bi bi-printer"></i></button>
  @endif
</div>
<div id="print">
<div class="row">
    <style type="text/css">
           th,td {
             border: 1px solid black;
            }

    </style>

          <!-- Start row -->
                    <div class="row mx-2" style="background-color:#eee;">

                                <div class="col-sm-6 mt-2">
                                    <div class="mt-2">
                                      @if (Session::get('data'))
                                      <img class="" src="{{ url('public/Image/'.Session::get('data')) }}" style="width: 100px; height: 80px;">
                                      @else @endif

                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2 text-end">
                                    <h3>INVOICE</h3>
                                    <h6>InvId.:&nbsp;{{$inv_details->id}}</h6>
                                    <h6>Invoice Date:&nbsp; {{$inv_details->created_at->format('d/m/Y')}}</h6>
                                    <h6>Payment Mode:&nbsp;Stripe</h6>
                                </div>

                    </div>
                    <!-- col-lg-6 end here -->
                    <div class="col-lg-12">
                        <!-- col-lg-12 start here -->

                        <div class="row mt-2" style="margin-left:1px;">
                            <div class="col-sm-6">
                            <ul class="list-unstyled">
                                <h6><strong>Bill To</strong></h6>
                                <h6>Name:&nbsp;{{$inv_details->ServiceLead->name}}</h6>
                                <h6>Country:&nbsp;{{$inv_details->ServiceLead->country_info->name}}</h6>
                                <h6>Email Address:&nbsp;{{$inv_details->ServiceLead->email}}</h6>
                                <h6>Contact Number:&nbsp;{{$inv_details->ServiceLead->phone}}</h6>
                            </ul>
                            </div>
                            <div class="col-sm-6">
                                <div class="text-end" >
                                 <a href="https://www.techturtleconsultant.com/">WWW.TECHTURTLECONSULTANT.COM</a>
                                </div>
                            </div>
                        </div>
                    </div>
            <div>
                      <table class="table border-collapse" border="1">
                        <thead style="background:#eee;">
                            <tr>
                            <th>ID</th>
                            <th>SERVICE NAME</th>
                            <th>PRICE($)</th>
                            <th>SERVICE TENURE</th>
                            <th>DISCOUNT</th>
                            <th>TOTAL($)</th>
                            </tr>
                        </thead>
                        @foreach($inv_history as $key=>$value)
                        <tr>
                            <td>{{++$key}}</td>
                            <td>{{$value->s_name}}</td>
                            <td>${{$value->service_amt}}</td>
                            <td>{{$value->s_tenure}} <br/>@if($value->s_extension){{$value->s_extension}} (Extension)@endif</td>
                            <td style="color:red;">@if($value->discount) - ${{$value->discount}} @else @endif</td>
                            <td>${{$value->service_amt - $value->discount}}</td>
                       </tr>
                       @endforeach
                        <tfoot >
                            <tr style="border:none;">
                                <td colspan="5" style="text-align: end;"><strong>Total</strong></td>
                                <td style="background-color:#eee; text-align: center;">${{$inv_details->total}}</td>
                            </tr>


                        </tfoot>
                    </table>
            </div>
            <div class="row mt-2">
                <div class="col-md-5" style="padding-left: 30px;">
                   <h6>RECEIVED BY:</h6>
                   <strong>GSTIN NO: </strong><br>
                   <strong>LUT:</strong>
                </div>
                <div class="col-md-6 text-end">
                    <h6>SIGNATURE</h6>
                    <p>........................</p>
                </div>
            </div>
            <div class="row">
                <div class="p-4">
                    <p>If you have any quires,you can reach us at:    <a href="https://info@techturtleconsultant.com">info@techturtleconsultant.com</a></p>
                    <P><strong style="color:red;">Disclaimer: </strong>Without digital seal invoice is not valid</P>

                </div>

            </div>
  </div>
</div>
</main>
<script type="text/javascript">
    function printPageArea(print) {
     var printContents = document.getElementById(print).innerHTML;
     var originalContents = document.body.innerHTML;

     document.body.innerHTML = printContents;

     window.print();

     document.body.innerHTML = originalContents;
}
</script>
@endsection





