@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Complains</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('/')}}" class="btn btn-rounded bg-grad-4 ml-4">

           <span class="btn-icon-left" style="color: white">
                Back
            </span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{ route('user_by_search.search') }}" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="user_id" type="button" data-toggle="dropdown">
                                    <option value="">Select User</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btn btn-primary" value="Filter">
                            </div>
                        </div>
                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>CUSTOMER Name</th>

                                     <th>COMPLAIN MSG</th>

                                     <th>COMPLAIN DATE</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                @if(!empty($complains))

                                @foreach($complains as $key=>$value)

                                <tr>

                                    <td>{{ ++$key }}</td>

                                    <td>{{ $value->User->name}}</td>

                                    <td>{{ $value->customer_name}}</td>

                                    <td>{{ $value->complain}}</td>

                                    <td>{{ date('d\m\y',strtotime($value->created_at));  }}</td>

                                    <td class="text-right">

                                         <a href="{{ route('complain.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                @endforeach

                                    @if ($complains->count() == 0)

                                    <tr class="text-center">

                                        <td colspan="6">No Complain to display.</td>

                                    </tr>

                                    @endif

                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                   <th>#</th>

                                    <th>NAME</th>

                                    <th>CUSTOMER Name</th>

                                     <th>COMPLAIN MSG</th>

                                     <th>COMPLAIN DATE</th>

                                    <th class="text-right">Action</th>


                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying {{$complains->count()}} of {{ $complains->total() }} Add Complain.</p>

                    </div>

                    {{--<div class="text-right float-right">

                          {{ $memberships->appends(request()->all())->links() }}

                    </div>--}}


                    <div class="pagination">
                        <ul class="pagination-list">
                            @if ($complains->currentPage() > 1)
                                <li class="pagination-item">
                                    <a href="{{ $complains->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                </li>
                            @endif

                            @if ($complains->currentPage() > 3)
                                <li class="pagination-item">
                                    <a href="{{ $complains->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            @endif

                            @foreach(range(max(1, $complains->currentPage() - 2), min($complains->lastPage(), $complains->currentPage() + 2)) as $page)
                                <li class="pagination-item {{ $page == $complains->currentPage() ? 'active' : '' }}">
                                    <a href="{{ $complains->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($complains->currentPage() < $complains->lastPage() - 2)
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="{{ $complains->appends(request()->all())->url($complains->lastPage()) }}" class="pagination-link">{{ $complains->lastPage() }}</a>
                                </li>
                            @endif

                            @if ($complains->hasMorePages())
                                <li class="pagination-item">
                                    <a href="{{ $complains->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 @endsection
