@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Add Category</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('category')}}" class="btn btn-info rounded-pill ">

            <span class="btn-icon-left text-primary">

                <i class="fa fa-arrow-left color-primary"></i>

            </span>Back

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('category.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                        @csrf

                        <!-- Modal body -->
                        <div class="row">


                            <div class="form-group col-lg-6">

                                <label>Brand Name <span class="text-danger">*</span></label>

                                <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Name">

                                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>

                            </div>



                            <div class="form-group col-lg-6">

                                <label>Image <span class="text-danger">*</span></label>

                                <input type="file" class="form-control" name="image" id="image">

                                <img id="preview-image-before-upload" height="100" class="mt-2">

                                <span class="text-danger"> @error('image'){{ $message }}@enderror </span>

                            </div>


                        </div>

                        <div class="text-center">

                            <button type="submit" class="btn btn-success">Submit</button>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

      </div>
</main><!-- End #main -->
 @endsection

 <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script type="text/javascript">

$(document).ready(function (e) {

   $('#preview-image-before-upload').hide();

   $('#image').change(function(){

    $('#preview-image-before-upload').show();

    let reader = new FileReader();

    reader.onload = (e) => {

      $('#preview-image-before-upload').attr('src', e.target.result);
    }

    reader.readAsDataURL(this.files[0]);

   });

});

</script>

