<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\Lead;

class MobileNumberValidation implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        
        // Query the leads table to check if the mobile number already exists
        $count = Lead::where('phone', $value)->count();

        // Return true if the count is 0 (number is not found), false otherwise
        return $count === 0;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
         return 'The phone number has already been taken.';
    }
}
