<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;


class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'mobile',
        'password',
        'role',
        'status',
        'DOB',
        'code',
        'profile',
        'state',
        'city',
        'district',
        'address',
        'registered_by',
        'shop_name',
        'free_trial',
        'quantity',
        'membership',
        'total_land',
        'crop_name',
        'photo'
    ];

    

    public function State(){
        return $this->hasOne(State::class,'id','state');
    }

    public function City(){
        return $this->hasOne(City::class,'id','city');
    }

    public function District()
    {
        return $this->hasOne(District::class,'id','district');
    }

    public function User_name()
    {
        return $this->hasOne(User::class,'id','registered_by');
    }

    public function Membership()
    {

        return $this->hasOne(Membership::class,'id','membership');
    }
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
