<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Attendence, User,State,District,City,Order, Report};
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;

class UserController extends Controller
{
   public function AllAgent(Request $request)
    {
        
        $user = User::where('role','Agent')->get();

        if ($request->search) {
            $user->where('name', 'like', '%' . $request->search . '%');
        }

        $users = User::where('role','Agent')->paginate(10);

        return view('frontend.Agent-view', compact('users', 'request'));
    }


   public function edit($id)
    {

        $id=decrypt($id);
        $users = User::find($id);
        $states = State::get(["state_name","id"]);
        
        return view('frontend.Agent-edit',compact('users','states'));
    }


    public function update($id,Request $request){
    $user=User::find($id);
    User::where('id',$id)->
    update([
        'name'=>$request->name,
        'email'=>$request->email,
        'mobile'=>$request->mobile,
        'DOB'=>$request->dob,
        'code'=>$request->code,
        'state'=>$request->state,
        'district'=>$request->district,
        'city'=>$request->city,
        'address'=>$request->address,
    ]);
    return redirect()->route('showallAgents');
   }

   public function View($id)
    {

        $id=decrypt($id);

        $users = User::find($id);
        if (!$users) {
            // Handle the case where the user doesn't exist
            return redirect()->route('error.page')->with('message', 'User not found');
        }

        $shop_generate_by_agent=User::where('role','Shop')->where('registered_by', $id)->orderBy('id','DESC')->get();

        $farmercard_generate_by_agent=User::where('role','Farmer')->where('registered_by', $id)->orderBy('id','DESC')->get();

        $attendances=Attendence::where('user_id', $id)->orderBy('id','DESC')->get();

    
        return view('frontend.Agentmore-view',compact('users','shop_generate_by_agent','farmercard_generate_by_agent','attendances'));
    }


   public function delete($id)
    {
        $id=decrypt($id);

        $users=User::find($id);

        $users->delete();

        return redirect('showallAgents')->with('error','Agent deleted successfully.');
    }

   public function NewAgent()
   {

    $states=State::get(['state_name','id']);

    return view('frontend.newAgent',compact('states'));

   }

   public function User_Store(Request $request)
   {

       if($request->newpassword)
       {

        if((Hash::check($request->password,Auth::user()->password))&&($request->newpassword==$request->renewpassword))
         {
            User::where('id',Auth::user()->id)->
            update([

                'password'=>Hash::make($request->newpassword),

            ]);
            return redirect()->route('users-profile')->with('success','Password update successfully...');
         }
          return redirect()->route('users-profile')->with('success','Password is incorrect');
       }

        if($request->profile)
        {
            if($request->file('profile')){
                $file= $request->file('profile');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }

            $id=Auth::user()->id;
            User::where('id',$id)->
                update([

                    'profile'=>$filename,

                ]);
           return redirect()->route('users-profile')->with('success','Profile Update Successfully');
        }

   }


   public function Agent_Store(Request $request)
   {
      
            $request->validate([
                'email'=>'required|email|unique:users,email',
            ]);

            $params['name']=$request->name;
            $params['email']=$request->email;
            $params['mobile']=$request->mobile;
            $params['DOB']=$request->dob;
            $params['code']=$request->code;
            $params['role']=$request->role;
            $params['password']=Hash::make($request->password);
            $params['state']=$request->state;
            $params['district']=$request->district;
            $params['city']=$request->city;
            $params['address']=$request->address;
            $user=User::create($params);
            $user->assignRole($request->role);
            return redirect()->route('showallAgents')->with('success','successfully registration..');
       

   }

    public function UserLogin(Request $request, $id){

        Auth::logout();

        Auth::loginUsingId($id);

        return redirect('/index');
    }


    public function Agent_Active($id){
        $data=User::find($id);
        if($data->status=='1'){
            $status='0';
        }else{
            $status='1';
        }
        $data->update([
            'status'=>$status
        ]);
        return back()->with('success', 'Agent status Update successfully.');

    }


    public function getState()
    {
        $data['states'] = State::get(["name","id"]);
        return view('state-city',$data);
    }

    public function getCity(Request $request)
    {
        $data['cities'] = City::where("state_id",$request->state_id)
                    ->get(["name","id"]);
        return response()->json($data);
    }
    public function getDistrict(Request $request)
    {
        $data['district'] = District::where("fk_state_master_id",$request->state_id)->
                    get(['dist_name','id']);
        return response()->json($data);
    }


}
