<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Suggestion,SocialLinks};
use App\Models\User;

class SuggestionController extends Controller
{
    public function index(Request $request)
    {
        $users = User::all();

        if($request->search){

            $suggestions = Suggestion::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $suggestions = Suggestion::orderBy('id','DESC')->paginate(10);
        }

        return view('suggestion.index',compact('suggestions','request','users'));
    }


    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::all();

        $suggestions = Suggestion::orderBy('id', 'desc')
            ->with('user')
            ->when($request->user_id, function ($query) use ($request) {
                $query->where('user_id', $request->user_id);
            })
            ->paginate(10);

        return view('suggestion.index', compact('suggestions', 'users', 'request'));
    }


    public function delete($id)
    {
        $id=decrypt($id);

        $suggestions = Suggestion::find($id);

        $suggestions->delete();

        return redirect('suggestions')->with('error','Suggestions deleted successfully.');
    }

    public function SocialUrl()
    {
        $links=SocialLinks::all();

        return view('frontend.Socialpage',compact('links'));
    
    }

    public function SocialEdit(Request $request,$id)
    {

        $links=SocialLinks::find($id)
        ->update([
            'url'=>$request->url
        ]);

        return back()->with('success', 'Social Url Update Successfully');
    }
}
