<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User,Role,State,City, Order,Order_history,FarmerOrder};
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class ShopController extends Controller
{

public function index(Request $request)
{
    $users = User::query();
  

    if ($request->search) 
    {
        $users = $users->where('name', 'like', '%' . $request->search . '%');
    }
    $users =User::where('role','Shop')->orderBy('id', 'desc')->paginate(10);

    return view('shop.index', compact('users', 'request'));
}


public function create()
{
    
    $states = State::get(["name","id"]);

    return "not done";
    
    return view('shop.create',compact('states'));

}

public function Shops_Store(Request $request)
{

    if($request->newpassword)
    {

        if((Hash::check($request->password,Auth::user()->password))&&($request->newpassword==$request->renewpassword))
        {
            User::where('id',Auth::user()->id)->
            update([

                'password'=>Hash::make($request->newpassword),

            ]);
            return redirect()->route('users-profile')->with('success','Password update successfully...');
        }
        return redirect()->route('users-profile')->with('success','Password is incorrect');
    }

        if($request->profile)
        {
            if($request->file('profile')){
                $file= $request->file('profile');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }

            $id=Auth::user()->id;
            User::where('id',$id)->
                update([

                    'profile'=>$filename,

                ]);
        return redirect()->route('users-profile')->with('success','Profile Update Successfully');
        }
    else
        {
            $request->validate([
                'email'=>'required|email|unique:users,email',
            ]);

            $params['name']=$request->name;
            $params['email']=$request->email;
            $params['mobile']=$request->mobile;
            $params['DOB']=$request->dob;
            $params['role']=$request->role;
            $params['group']=$request->group;
            $params['password']=Hash::make($request->password);
            $params['headquater']=$request->headquater;
            $params['state']=$request->state;
            $params['city']=$request->city;
            $params['pincode']=$request->pincode;
            $params['bank_details']=$request->bank_details;
            $user=User::create($params);
            $user->assignRole($request->role);
            return redirect()->route('allShops')->with('success','successfully registration..');
    }

}


public function edit($id)
{

    $id=decrypt($id);

    $users = User::find($id);
    $role=Role::all();
    $groups=Group::all();
    $states = State::get(["name","id"]);
    $cities = City::get(["name","id"]);
    $head_quaters = HeadQuater::get(["name","id"]);

    return view('shop.edit',compact('users','role','groups','states','head_quaters','cities'));

}

public function View($id)
{
    $id = decrypt($id);

    $users = User::find($id);

    if (!$users) 
    {
        // Handle the case where the user doesn't exist
        return redirect()->route('error.page')->with('message', 'User not found');
    }

    // Retrieve only the orders associated with the given user ID
    $orders = Order::where('user_id', $id)->get();

    $farmer_order=FarmerOrder::where('shop_id',$id)->get();
   
    return view('shop.view', compact('users', 'orders','farmer_order'));

}



public function update($id,Request $request){
    $user=User::find($id);
    $user->assignRole($request->role);
    User::where('id',$id)->
    update([
        'name'=>$request->name,
        'role'=>$request->role,
        'group'=>$request->group,
        'email'=>$request->email,
        'mobile'=>$request->mobile,
        'DOB'=>$request->dob,
        'password'=>Hash::make($request->password),
        'headquater'=>$request->headquater,
        'state'=>$request->state,
        'city'=>$request->city,
        'pincode'=>$request->pincode,
        'bank_details'=>$request->bank_details
    ]);
    return redirect()->route('allShops')->with('success','successfully Update Users..');
}


public function delete($id)
{
    $id=decrypt($id);

    $users=User::find($id);

    $users->delete();

    return redirect('allShops')->with('error','Customer deleted successfully.');
}



public function Shop_Active($id){
    $data=User::find($id);
    if($data->status=='1'){
        $status='0';
    }else{
        $status='1';
    }
    $data->update([
        'status'=>$status
    ]);
    return back()->with('success', 'Shop status Update successfully.');

}

public function Order_History($id)
{
    

    $order_histories=Order_history::where('order_id',$id)->paginate(15);

    return view('shop.order_history',compact('order_histories'));

}

public function getState()
{
    $data['states'] = State::get(["name","id"]);
    return view('state-city',$data);
}
public function getCity(Request $request)
{
    $data['cities'] = City::where("state_id",$request->state_id)
                ->get(["name","id"]);
    return response()->json($data);
}

}
