<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Models\{Order_history,FarmerOrder,Company};
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $users = User::where('role','Agent')->get();

        $orders = Order::orderBy('id','DESC')->paginate(10);
       
        return view('order.index',compact('orders','users'));
    }

    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::where('role', 'Agent')->get();

        $ordersQuery = Order::orderBy('id', 'desc')
        ->with(['user']);


        if($request->date_to && $request->from && $request->user_id)
        {
           $ordersQuery=when(
                $request->date_from && $request->date_to,
                function (Builder $builder) use ($request) {
                    $builder->whereBetween(
                        DB::raw('DATE(created_at)'),
                        [
                            $request->date_from,
                            $request->date_to
                        ]
                    );
                }
            )->where('user_id', $request->user_id);
        }

        

        elseif($request->user_id)
        {
            $ordersQuery->where('user_id', $request->user_id);
        }

        elseif($request->date_to && $request->date_from)
        {
            $ordersQuery->when(
                $request->date_from && $request->date_to,
                function (Builder $builder) use ($request) {
                    $builder->whereBetween(
                        DB::raw('DATE(created_at)'),
                        [
                            $request->date_from,
                            $request->date_to
                        ]
                    );
                }
            );
        }
        else
        {

        }

        $orders = $ordersQuery->paginate(10);

        return view('order.index', compact('orders', 'users', 'request'));
    }


    public function View_details( $id)
    {
        $id = decrypt($id);
       
        $orders = Order::with('user')->find($id);
        $company=Company::get()->first();
        $order_histories = Order_history::where('order_id', $id)->get();
        return view('order.view_details',compact('orders','order_histories','company'));
    }

    public function delete($id)
    {
        $id=decrypt($id);

        $orders = Order::find($id);

        $orders->delete();

        return redirect('orders')->with('error','Order deleted successfully.');
    }


    public function Farmer_index(Request $request)
    {   

        $far_order=FarmerOrder::orderBy('id','DESC')->paginate(10);
        
        
        return view('farmer_order.index',compact('far_order','request'));

    }

    public function Farmer_search(Request $request)
    {
        // Fetch only users with the role 'Employee'
       
        $farmerordersQuery =FarmerOrder::orderBy('id', 'desc')
        ->with(['shop_name']);

    
        if($request->date_to && $request->from && $request->farmer_code_filter)
        {
           $farmerordersQuery=when(
                $request->date_from && $request->date_to,
                function (Builder $builder) use ($request) {
                    $builder->whereBetween(
                        DB::raw('DATE(created_at)'),
                        [
                            $request->date_from,
                            $request->date_to
                        ]
                    );
                }
            )->where('farmer_code',$request->farmer_code_filter); 
        }

        elseif($request->farmer_code_filter)
        {
            $farmerordersQuery->where('farmer_code',$request->farmer_code_filter);
        }

        elseif($request->date_to && $request->date_from)
        {
            $farmerordersQuery->when(
                $request->date_from && $request->date_to,
                function (Builder $builder) use ($request) {
                    $builder->whereBetween(
                        DB::raw('DATE(created_at)'),
                        [
                            $request->date_from,
                            $request->date_to
                        ]
                    );
                }
            );
        }
        else
        {

        }

       
        $far_order = $farmerordersQuery->paginate(10);

        return view('farmer_order.index', compact('far_order', 'request'));
    }

    public function Farmer_Delete($id)
    {
        $id=decrypt($id);

        $farmer_order = FarmerOrder::find($id);

        $farmer_order->delete();

        return back()->with('error','Order deleted successfully.');
    }

    public function Farmer_View($id)
    {

    }
}
