<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Complain;
use App\Models\User;

class ComplainController extends Controller
{
    public function index(Request $request){

        $users = User::all();

        if($request->search){

            $complains = Complain::orderBy('id','DESC')->where('date', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $complains = Complain::orderBy('id','DESC')->paginate(10);
        }

        return view('complain.index',compact('complains','request','users'));
    }

    public function search(Request $request)
    {
        $users = User::all();

        $complains = Complain::orderBy('id', 'desc')
            ->with('user')
            ->when($request->user_id, function ($query) use ($request) {
                $query->where('user_id', $request->user_id);
            })
            ->paginate(10);

        return view('complain.index', compact('complains', 'users', 'request'));
    }

    public function delete($id)
        {
            $id=decrypt($id);

            $complains = Complain::find($id);

            $complains->delete();

            return redirect('complain')->with('error','Complain deleted successfully.');
        }
}
