<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Company,City,State,Country,Service_Invoice_History,Source,Lead,Group,GroupUsers,User,ServiceInvoice,Remark,AssignLead};
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Mail\Mailable;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportLeads;

class CompanyServiceController extends Controller
{

    // public function index(Request $request)
    // {
    //      $id=$request->id;
    //      $lead=Lead::find($id);
    //     return view('frontend.invoice-generate',compact('lead'));
    // }


    public function ShowForgetPasswordForm(){
        return view('frontend.forgetpassword');
    }

     public function SubmitForgetPasswordForm(Request $request){
        $request->validate([
              'email' => 'required|email|exists:users',
          ]);
         $token = Str::random(64);

         DB::table('password_resets')->insert([
              'email' => $request->email,
              'token' => $token,
              'created_at' => Carbon::now(),
            ]);

        Mail::send('frontend.resetpassword', ['token' => $token], function($message) use($request){
              $message->to($request->email);
              $message->subject('Reset Password');
        });

        return back()->with('message', 'We have e-mailed your password reset link!');
    }

    //  public function ShowResetPasswordForm(Request $request){
    //      return view('frontend.createnewpassword', ['token' => $token]);
    // }

     public function SubmitResetPasswordForm(Request $request){
        $request->validate([
              'email' => 'required|email|exists:users',
              'password' => 'required|string|min:6|confirmed',
              'password_confirmation' => 'required'
          ]);

          $updatePassword = DB::table('password_resets')
                              ->where([
                                'email' => $request->email,
                                'token' => $request->token
                              ])
                              ->first();

          if(!$updatePassword){
              return back()->withInput()->with('error', 'Invalid token!');
          }

          $user = User::where('email', $request->email)
                      ->update(['password' => Hash::make($request->password)]);

          DB::table('password_resets')->where(['email'=> $request->email])->delete();

        return redirect('/login')->with('message', 'Your password has been changed!');
    }

    public function ShowServiceInvoice(){
        $serviceinv=ServiceInvoice::where('company_id',Auth::user()->company_id)->orderby('id','desc')->get();
        return view('frontend.serviceinvoicepage',compact('serviceinv'));
    }

    public function RemarkSave($id,Request $request){

        $request->validate([
            'followup_type'=>'required',
            'description'=>'required'
        ]);
        $params['lead_id']=$id;
        $params['user_id']=Auth::user()->id;
        $params['description']=$request->description;
        $params['followup_type']=$request->followup_type;
        Remark::create($params);
        return back();
    }

    public function RemarkDelete($id){
        $remark=Remark::find($id);
        $lead=Remark::find($id);
        $remark->delete();
        return redirect()->route('/leadmoreview',['id'=>$lead->lead_id]);
    }

    public function EditRemark($id,Request $request){

         $request->validate([
            'followup_type'=>'required'
        ]);
        Remark::where('id',$id)
        ->update([
            'description'=>$request->description,
            'followup_type'=>$request->followup_type,
        ]);
        $lead=Remark::find($id);
        return redirect()->route('/leadmoreview',['id'=>$lead->lead_id]);
    }

    public function ImportView(){
        return view('frontend.import-page');
    }

    public function DataImport(Request $request){
        Excel::import(new ImportLeads,request()->file('file'));
        return back();

    }




}
