<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{CategoryMaster,Membership};

class CategoryMasterController extends Controller
{

    public function index(Request $request)
    {

        if($request->search){

            $category_masters = CategoryMaster::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);

        } else
        {
            $category_masters = CategoryMaster::orderBy('id','DESC')->paginate(10);
        }

        return view('categorymaster.index',compact('category_masters','request'));
    }

    public function create()
    {

        return view('categorymaster.create');

    }

    public function store(Request $request)
    {

    $this->validate($request,[
        'name' => 'required',
        'image' => 'required',
    ]);

    if($request->hasFile('image'))
    {
        $imageName = time().'.'.$request->image->extension();

        $path = $request->image->move(public_path('/uploads/category/'), $imageName);

        $data['image'] = $imageName;
    }
        $data['name'] = $request->name;

        $category = CategoryMaster::create($data);

        if ($category ) {
            return redirect('category')->with('success', 'Category created successfully.');
        } else {
            return redirect('category')->with('error', 'Something went wrong.');
        }
    }

        
    public function edit($id)
    {
        $id=decrypt($id);

        $category = CategoryMaster::find($id);

        return view('categorymaster.edit',compact('category'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name' => 'required',
        ]);

        $category= CategoryMaster::find($id);

        $data = [

            'name' => $request->name,
        ];

    if ($request->hasFile('image'))
    {
        $imageName = time() . '.' . $request->image->extension();

        $path = $request->image->move(public_path('/uploads/category/'), $imageName);

        $data['image'] = $imageName;
    }

        $category->update($data);

        return redirect('category')->with('success', 'Category  updated successfully.');
    }


    public function delete($id)
    {
        $id=decrypt($id);

        $category = CategoryMaster::find($id);

        $category->delete();

        return redirect('category')->with('error','Category deleted successfully.');
    }

    public function Membership_index(Request $request)
    {
        $membership=Membership::orderBy('id','DESC')->get();
        return view('membership.index',compact('request','membership'));
    }

    public function Membership_create()
    {
        return view('membership.create');
    }

    public function Membership_store(Request $request)
    {

        if($request->hasFile('image'))
        {
            $imageName= date('YmdHi'). '.' . $request->image->extension();
            $path= $request->image->move(public_path('/uploads/membership/'), $imageName);
            $data['image'] = $imageName;
        }

        $data['title']=$request->title;
        $data['description']=$request->description;

        $membership=Membership::create($data);

        if ($membership) 
        {
            return redirect('Memberships')->with('success', 'Membership created successfully.');
        } 
        else 
        {
            return redirect('Memberships')->with('error', 'Something went wrong.');
        }

    }

    public function Membership_edit($id)
    {
        $id=decrypt($id);
        $membership=Membership::find($id);

        return view('membership.edit',compact('membership'));

    }

    public function Membership_update($id, Request $request)
    {

        if ($request->hasFile('image'))
        {
            $imageName = time() . '.' . $request->image->extension();

            $path = $request->image->move(public_path('/uploads/membership/'), $imageName);

        }
        membership::find($id)
        ->update([
            'title'=>$request->title,
            'description'=>$request->description,
            'image'=>$imageName
        ]);
        return redirect('Memberships')->with('success','Membership updated successfully');


    }

    public function Membership_delete($id)
    {
        $id=decrypt($id);

        $membership = Membership::find($id);

        $membership->delete();

        return redirect('Memberships')->with('error','Membership deleted successfully.');

    }

}
