<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Attendence;
use App\Models\User;
use Carbon\Carbon;

class AttendenceController extends Controller
{
    public function index(Request $request)
    {

        $users = User::where('role', 'Agent')->get();

        
        $attendences = Attendence::orderBy('id','DESC')->paginate(10);
        

        return view('attendence.index',compact('attendences','users'));
    }



    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::where('role', 'Agent')->get();

        $attend = Attendence::orderBy('id', 'desc')
            ->with(['user']);

        $month=date('m' ,strtotime($request->date_filter));

        if($request->user_id && $request->date_filter)
        {
            $attend->where('user_id', $request->user_id)->whereMonth('date', $month);
            
        }

        if($request->user_id)
        {
            $attend->where('user_id', $request->user_id);
          
            
        }

        if($request->date_filter)
        {
            $attend->whereMonth('date', $month);
        }

        $attendences= $attend->paginate(10);

        return view('attendence.index', compact('attendences', 'users'));
    }

    

    public function delete($id)
    {
        $id=decrypt($id);

        $attendence = Attendence::find($id);

        $attendence->delete();

        return redirect('attendence')->with('error','Attendance deleted successfully.');
    }
}
