<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use App\Models\{AddProduct, Attendence, Membership, CategoryMaster, User,Complain,Order, Order_history,Slider,Report,Suggestion,Leave,Country,State,District,FarmerOrder,SocialLinks};
use DateTime;
use DatePeriod;
use DateInterval;
use Auth;
use Illuminate\Support\Facades\Validator;


class ApiController extends Controller
{
    public function login(Request $request)
    {
        $this->validate($request,[
            'password' => 'required',
            'email' => 'required'
        ]);

        $email = $request->input('email');
        $password = $request->input('password');
        

        if(Auth::attempt(['email'=>$email,'password'=>$password]))
        {

            $user = Auth::user();

            $state=State::where('id',$user->state)->select('state_name')->first();

            $district= District::where('id',$user->district)->select('dist_name')->first();

            $formatteddata = 
            [
                    'id' => $user->id,
                    'name' => $user->name,
                    'status' => $user->status,
                    'state' =>  $state->state_name,
                    'district' => $district->dist_name,
                    'role' => $user->role,
                    'mobile' => $user->mobile,
                    'email' => $user->email,
                    'profile' => $user->profile,
                    'DOB' => $user->DOB,
                    'code' => $user->code,
                    'free_trial' => $user->free_trial,
                    'quantity' => $user->quantity,
                    'city' => $user->city,
                    'address' => $user->address,
                    'registered_by' => $user->registered_by,
                    'shop_name' => $user->shop_name,
                    'created_at' => Carbon::parse($user->created_at)->format('d-m-Y')                    
            ];
        

            return response()->json([
            'status' => 'true',
            'msg' => 'User logged in successfully!',
            'data' => $formatteddata
            ], 200);

        }

        
        else 
        {
                // Check if the email is correct
                $user = User::where('email', $email)->first();
                
                if (!$user) 
                {
                    return response()->json([
                        'status' => 'false',
                        'msg' => 'Incorrect email entered!',
                    ], 200);
                } 
                else 
                {
                    return response()->json([
                        'status' => 'false',
                        'msg' => 'Incorrect password entered!',
                    ], 200);
                }
        }

        
    }


    public function productShow(Request $request)
    {

        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $products = AddProduct::where('status', 1)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($products->isEmpty()) 
        {
            return response()->json([
                'status' => 'false',
                'msg' => 'Products not found.',
            ], 404);
        } 
        else 
        {
            // $formattedProducts = $products->map(function ($product) {
            //     return [
            //         'id' => $product->id,
            //         'name' => $product->name,
            //         'unit' => $product->unit,
            //         'group' => $product->Group->name,
            //         'image' => $product->image,
            //         'hsn_code' => $product->hsn_code,
            //         'stock_qty' => $product->stock_qty,
            //         'sale_price' => $product->sale_price,
            //         'opening_stock' => $product->opening_stock,
            //         'part_no' => $product->part_no,
            //         'status' => $product->status,
            //         'created_at' => $product->created_at,
            //         'updated_at' => $product->updated_at,
            //     ];
            // });

            return response()->json([
                'status' => 'true',
                'msg' => 'All products retrieved successfully.',
                'data' => $products,
            ], 200);
        }
    }


    public function productShowByid($id)
    {

       
        $product = AddProduct::find($id);

        if (!$product) 
        {
            return response()->json(['status' => 'false','msg' => 'Product Not found',
            ], 404);
        } 
        else 
        {
            // Manipulate the data before returning
            // $formattedData = [
            //     'id' => $product->id,
            //         'name' => $product->name,
            //         'unit' => $product->unit,
            //         'group' => $product->Group->name,
            //         'image' => $product->image,
            //         'hsn_code' => $product->hsn_code,
            //         'status' => $product->status,
            //         'stock_qty' => $product->stock_qty,
            //         'sale_price' => $product->sale_price,
            //         'opening_stock' => $product->opening_stock,
            //         'part_no' => $product->part_no,
            //         'created_at' => $product->created_at,
            //         'updated_at' => $product->updated_at,
            // ];

            return response()->json(['status' => 'true','data' => $product,
            ], 200);
        }
    }


    public function Category_Show(Request $request)
    {
        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $category = CategoryMaster::orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($category->isEmpty()) 
        {
            return response()->json(['status' => 'false','msg' => 'Category not found.',], 404);
        } 
        else
        {
            return response()->json(['status' => 'true','msg' => 'All Category retrieved successfully.','data' => $category,
            ], 200);
        }
    }


    public function Membership_Show()
    {
        // $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        // $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $membership = Membership::orderby('id','desc')->get();


        if ($membership->isEmpty()) 
        {
            return response()->json(['status' => 'false','msg' => 'Membership not found.',], 404);
        } 
        else
        {

        return response()->json(['status' => 'true','msg' => 'All Membership retrieved successfully.','data' =>$membership,
            ], 200);
        }

    }

    public function HomeBanner_Show()
    {
        $slider = Slider::select('app_sign_first_slider','app_sign_second_slider','app_sign_third_slider','app_sign_forth_slider','app_sign_fifth_slider')->first();

        if ($slider==null) 
        {
            return response()->json(['status' => 'false','msg' => 'Slider not found.'], 404);
        } 
        else
        { 
            $data=array();
            $firstdata['appslider']=$slider->app_sign_first_slider; 
            array_push($data,$firstdata);
            $seconddata['appslider']=$slider->app_sign_second_slider; 
            array_push($data,$seconddata);
            $thirddata['appslider']=$slider->app_sign_third_slider; 
            array_push($data,$thirddata);
            $forthdata['appslider']=$slider->app_sign_forth_slider;
            array_push($data,$forthdata);
            $fifthdata['appslider']=$slider->app_sign_fifth_slider; 
            array_push($data,$fifthdata);  
            return response()->json(['status' => 'true','msg' => 'All Slider retrieved successfully.','data' => $data,
            ], 200);
        }

    }

    

    public function ShopSave(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
        'email'=>'required|email|unique:users,email',
       
        ]);

        if ($validator->fails()) 
        {
            return response()->json([
                'error' => 'Validation failed',

                'message' => 'Enter Unique Email..'

            ], 422); // 422 Unprocessable Entity
        }


        $params['name']=$request->name;
        $params['email']=$request->email;
        $params['mobile']=$request->mobile;
        $params['shop_name']=$request->shop_name;
        $params['code']=$request->code;
        $params['role']='Shop';
        $params['password']=Hash::make($request->password);
        $params['state']=$request->state;
        $params['city']=$request->city;
        $params['district']=$request->district;
        $params['address']=$request->address;
        $params['registered_by']=$request->registered_by;
        $user=User::create($params);
        
        $user->assignRole('Shop');
        
        if($user)
        {
            return response()->json(['status'=>'true','msg'=>'Shop Registration','data'=>$user],200);
        }

        return response()->json(['status' => 'false','msg' => 'Try Again.'], 404);

    }

    public function ShowShop(Request $request)
    {
        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $shops=User::where('registered_by', $request->user_id)->where('role','Shop')->whereMonth('created_at',Carbon::now()->month)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($shops->isEmpty()) 
        {
            return response()->json(['status' => 'false','msg' => 'Shops not found.'], 404);
        } 
        else
        {
            return response()->json(['status' => 'true','msg' => 'All Shops retrieved successfully.','data' => $shops,
            ], 200);
        }

    }


    public function FarmerSave(Request $request)
    {

        if($request->file('photo'))
        {
                $file= $request->file('photo');
                $imageName= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('/uploads/farmer/'), $imageName);  
                $params['photo']=$imageName;   
            
        }
        
        $params['name']=$request->name;
        $params['mobile']=$request->mobile;
        $params['free_trial']=$request->free_trial;
        $params['quantity']=$request->quantity;
        $params['code']=$request->code;
        $params['role']='Farmer';
        $params['state']=$request->state;
        $params['district']=$request->district;
        $params['city']=$request->city;
        $params['address']=$request->address;
        $params['registered_by']=$request->registered_by;
        $params['membership']=$request->membership;
        $params['total_land']=$request->total_land;
        $params['crop_name']=$request->crop_name;

        $user=User::create($params);
        
        $user->assignRole('Farmer');
        if($user)
        {
            return response()->json(['status'=>'true','msg'=>'Farmer Registration','data'=>$user],200);
        }

        return response()->json(['status' => 'false','msg' => 'Try Again.'], 404);
    }

    public function ShowFarmers(Request $request)
    {
        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        
        $farmers=User::where('registered_by',$request->user_id)->where('role','Farmer')->whereMonth('created_at',Carbon::now()->month)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($farmers->isEmpty()) 
        {
            return response()->json(['status' => 'false','msg' => 'Farmers not found.'], 404);
        } 
        else
        {

            $formattedData = $farmers->map(function ($farmer) {
                return [

                    'id' => $farmer->id,
                    'name' => $farmer->name,
                    'status' => $farmer->status,
                    'role' => $farmer->role,
                    'mobile' => $farmer->mobile,
                    'email' => $farmer->email,
                    'profile' => $farmer->profile,
                    'DOB' => $farmer->DOB,
                    'code' => $farmer->code,
                    'free_trial' => $farmer->free_trial,
                    'quantity' => $farmer->quantity,
                    'membership'=> $farmer->Membership->title,
                    'city' => $farmer->city,
                    'address' => $farmer->address,
                    'registered_by' => $farmer->registered_by,
                    'shop_name' => $farmer->shop_name,
                    'total_land' => $farmer->total_land,
                    'crop_name' => $farmer->crop_name,
                    'photo' => $farmer->photo,
                    'created_at' => Carbon::parse($farmer->created_at)->format('d-m-Y')       
                ];
            });

            return response()->json(['status' => 'true','msg' => 'All Farmers retrieved successfully.','data' => $formattedData,
            ], 200);
        }
        
    }


    public function Complain_Store(Request $request)
    {

        $complains = Complain::create([
        'customer_name' => $request->input('customer_name'),
        'complain' => $request->input('complain'),
        'user_id' => $request->input('user_id')
        ]);

        if ($complains) 
        {
            return response()->json(['status' =>'true','message' => 'Complain created successfully'], 200);
        } 
        else 
        {
            return response()->json(['status' =>'false','message' => 'Failed to create Complain'], 200);
        }

    }


    public function Complain_Show(Request $request)
    {

        $this->validate($request,[
        'user_id'=>'required'
        ]);

        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $user_id = $request->input('user_id');

        $complains = Complain::where('user_id', $user_id)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($complains->isEmpty()) 
        {
            return response()->json(['status' => 'false','msg' => 'No complains found for the given User ID.',
             ], 200);
        } 
        else 
        {
            $formattedComplain = $complains->map(function ($complain) {
                return [
                    'id' => $complain->id,
                    'user_id' => $complain->user_id,
                    'customer_name'=>$complain->customer_name,
                    'complain' => $complain->complain,
                    'created_at' => Carbon::parse($complain->created_at)->format('Y-m-d'),
                ];
            });

            return response()->json(['status' => 'true','msg' => 'All User Id base data','data' => $formattedComplain,
            ], 200);
        }
    }




    public function Suggestion_Store(Request $request)
    {

        $suggestions = Suggestion::create([
        'user_id' => $request->input('user_id'),
        'suggestion' => $request->input('suggestion')
        ]);

        if ($suggestions) {
            return response()->json(['status' =>'true','message' => 'Suggestions created successfully'], 200);
        } else {
            return response()->json(['status' =>'false','message' => 'Failed to create Suggestions'], 200);
        }

    }


    public function Suggestion_Show(Request $request)
    {
        $this->validate($request, [
            'user_id' => 'required'
        ]);

        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $user_id = $request->input('user_id');

        $suggestions = Suggestion::where('user_id', $user_id)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();

        if ($suggestions->isEmpty()) {
            return response()->json([
                'status' => 'false',
                'msg' => 'No suggestions found for the given User ID.',
            ], 200);
        } 
        else 
        {
            $formattedSuggestions = $suggestions->map(function ($suggestion) {
                return [
                    'id' => $suggestion->id,
                    'user_id' => $suggestion->user_id,
                    'suggestion' => $suggestion->suggestion,
                    'created_at' => Carbon::parse($suggestion->created_at)->format('Y-m-d'),
                ];
            });

            return response()->json([
                'status' => 'true',
                'msg' => 'All User Id base data',
                'data' => $formattedSuggestions 
            ], 200);
        }
    }


    public function Suggestion_Delete(Request $request)
    {

        $id = $request->input('id');

        $suggestions = Suggestion::where('id', $id)->first();
        if ($suggestions) {
            $suggestions->delete();
            return response()->json(['status'=>'true','message' => 'Suggestion deleted successfully'], 200);
        }
        return response()->json(['status'=>'false','error' => 'Suggestion not found'], 200);
    }


    public function Attendence_Store(Request $request)
    {
            config(['app.timezone' => 'Asia/Kolkata']);

            $user_id = $request->input('user_id');
            $date = Carbon::now()->format('Y-m-d');

            $formattedDayOfWeek = Carbon::now()->format('l'); // Get the day of the week

            if ($formattedDayOfWeek === 'Sunday') {
                return response()->json([
                    'status' => 'false',
                    'message' => 'Today is Sunday. No attendance on Sundays.',
                ], 200);
            }

            $existingLeaveEntry = Leave::where('user_id', $user_id)
                ->whereDate('start_date', '<=', $date)
                ->whereDate('end_date', '>=', $date)
                ->exists();

            if ($existingLeaveEntry) {
                return response()->json([
                    'status' => 'false',
                    'message' => 'You are on leave today. Attendance not created.',
                ], 200);
            }

            $existingEntry = Attendence::where('user_id', $user_id)
                ->whereDate('date', $date)
                ->exists();

            if ($existingEntry) {
                return response()->json([
                    'status' => 'false',
                    'message' => 'Reports entry for today already exists. Try again tomorrow.',
                ], 200);
            }

            $time_in = Carbon::now()->format('H:i:s');

            // Create a new attendance entry
            $attendance = Attendence::create([
                'user_id' => $user_id,
                'longitude' => $request->input('longitude'),
                'latitude' => $request->input('latitude'),
                'location' => $request->input('location'),
                'time_in' => $time_in,
                'time_status' => 1,
                'date' => $date,
            ]);

            if ($attendance) {
                // Fetch the formatted time and date for the response
                $formattedTimeIn = Carbon::createFromFormat('H:i:s', $attendance->time_in)->format('h:i A');
                $formattedDate = Carbon::createFromFormat('Y-m-d', $attendance->date)->format('Y-m-d');
                $responseMessage = 'Attendance created successfully';
                return response()->json([
                    'status' => 'true',
                    'message' => $responseMessage,
                    'data' => [
                        'time_in' => $formattedTimeIn,
                        'date' => $formattedDate,
                    ],
                ], 200);
            } else {
                return response()->json(['status' => 'false', 'message' => 'Failed to create attendance'], 200);
            }
    }


    public function Attendence_Update(Request $request)
    {
            $user_id = $request->input('user_id');
            $longitude_out = $request->input('longitude_out');
            $latitude_out = $request->input('latitude_out');
            $location_out = $request->input('location_out');

            config(['app.timezone' => 'Asia/Kolkata']); // Set the timezone to 'Asia/Kolkata'

            $time_out = Carbon::now()->format('H:i:s'); // Get the current time for time_out

            // Find the user based on the mobile number
            $attendence = Attendence::where('user_id', $user_id)->latest('date')
            ->latest('created_at')
            ->first();

            $attendence->update([
                'user_id' => $user_id,
                'longitude_out' => $longitude_out,
                'latitude_out' => $latitude_out,
                'location_out' => $location_out,
                'time_status' => 2,
                'time_out' => $time_out // Update the time_out field with the current time
            ]);

            // Fetch the formatted time and date for the response
            $formattedTimeOut = Carbon::createFromFormat('H:i:s', $time_out)->format('h:i A');

            return response()->json([
                'status' => 'true',
                'message' => 'Attendence updated successfully',
                'data' => [
                    'time_out' => $formattedTimeOut,
                ],

            ], 200);
    }


    public function Attendence_Day(Request $request)
    {
            $this->validate($request, [
                'user_id' => 'required',
            ]);

            $user_id = $request->input('user_id');

            $today = date('Y-m-d'); // Get the current date in the 'Y-m-d' format

            $attendance = Attendence::where('user_id', $user_id)
                ->whereDate('date', '=', $today) // Filter by today's date in 'Y-m-d' format
                ->latest('created_at')
                ->first();

            if (!$attendance) {
                return response()->json([
                    'status' => 'false',
                    'msg' => 'No Attendance found for the given User ID today.',
                ], 200);
            } else {
                return response()->json([
                    'status' => 'true',
                    'msg' => 'Last Attendance data for the specified user_id',
                    'data' => $attendance,
                ], 200);
            }
    }




    public function Attendence_Show($id)
    {
        $sdate=date("Y-m-d", strtotime(" -1 months"));
        $edate=date('Y-m-d');
        $user_id=User::find($id);

        $attendance = Attendence::where('user_id',$user_id->id)->where('time_status','1')->get();

        if($attendance)
        {
            $leave_dates=$this->getDatesFromRange($sdate, $edate);

                 $atten_date = array();
                 foreach ($attendance as $row)
                 {
                    $atten_date[]=$row->date;
                    $row->day=$day = date('l', strtotime($row->date));
                    $row->label='';
                 }

                 $date_range = array_merge(array_diff($leave_dates, $atten_date));

                 $attendance=array();

                 foreach ($leave_dates as $leave_value) {

                    if(in_array($leave_value,$atten_date))
                    {
                        $day = date('l', strtotime($leave_value));
                        $attendance[] = (object) array( 'id'=>'', 'user_id'=>$user_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'',  'day' => $day, 'label' => 'attendance' );
                    }

                    if( !in_array( $leave_value, $date_range ))
                    {
                        continue;
                    }

                    if( date('l', strtotime($leave_value)) == 'Sunday' ){
                        $attendance[] = (object) array( 'id'=>'', 'user_id'=>$user_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'',  'day' => 'Sunday', 'label' => 'Holiday' );
                    }else{

                        $leave_check=Leave::where('user_id',$user_id->id)->where('start_date','<=', $leave_value)->where('end_date','>=', $leave_value)->where('status','1')->get();



                        // if($leave_check)
                        if(count($leave_check)!=0)
                        {
                            $day = date('l', strtotime($leave_value));
                            $attendance[] = (object) array( 'id'=>'', 'user_id'=>$user_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'', 'day' => $day, 'label' => 'Leave' );
                        }
                        else
                        {
                            $day = date('l', strtotime($leave_value));
                            $attendance[] = (object) array('id'=>'', 'user_id'=>$user_id->id, 'date' => $leave_value, 'time_in'=>'', 'time_out'=>'','time_status'=>'', 'day' => $day, 'label' => 'Absent' );
                        }
                    }
                 }


                 $wek=array();
                foreach ($attendance as $key => $row)
                {
                    $wek[$key]  = $row->date;
                }

                // // Sort the data with wek ascending order, add $mar as the last parameter, to sort by the common key
                array_multisort($wek, $attendance);


                return response()->json([
                'status' => true,
                'message' => "attendance",
                'response'=>$attendance
                ],200);
        }
        else
        {
            return response()->json([
            'status' => false,
            'message' => "No record found!",
            ],404);
        }
    }

    // Function to get all the dates in given range 
    public function getDatesFromRange($start, $end, $format = 'Y-m-d') 
    { 
          
        // Declare an empty array 
        $array = array(); 
        // Variable that store the date interval 
        // of period 1 day 
        $interval = DateInterval::createFromDateString('1 day');
        $realEnd = new DateTime($end); 
        $realEnd->add($interval); 
        $period = new DatePeriod(new DateTime($start), $interval, $realEnd); 
        // Use loop to store date into array 
        foreach($period as $date) {                  
            $array[] = $date->format($format);  
        } 
        // Return the array elements 
        return $array; 
    }

    public function Leave_Store(Request $request)
    {

            $this->validate($request, [
                'user_id' => 'required'
            ]);

            $leaves = Leave::create([
                'user_id' => $request->input('user_id'),
                'start_date' => $request->input('start_date'),
                'end_date' => $request->input('end_date'),
                'leave_msg' => $request->input('leave_msg'),
                'user_latitude' => $request->input('user_latitude'),
                'user_longitude' => $request->input('user_longitude'),
                'user_location' => $request->input('user_location')
                ]);

                if ($leaves) {
                    return response()->json(['status' =>'true','message' => 'Leave created successfully'], 200);
                } else {
                    return response()->json(['status' =>'false','message' => 'Failed to create Leave'], 200);
                }

    }



    public function Report_Save(Request $request)
    {
            $user_id = $request->input('user_id');
            $date = $request->input('date');
            $message = $request->input('message');

            // Check if a report exists for the given user and date
            $report = Report::where('user_id', $user_id)
                        ->where('date', $date)
                        ->first();

            if ($report) {
                // If a report already exists, update the message
                $report->update([
                    'message' => $message
                ]);

                return response()->json(['status' =>'true','message' => 'Report updated successfully'], 200);
            } else {
                // If no report exists, create a new one
                $newReport = Report::create([
                    'user_id' => $user_id,
                    'date' => $date,
                    'message' => $message
                ]);

                if ($newReport) {
                    return response()->json(['status' =>'true','message' => 'Report created successfully'], 200);
                } else {
                    return response()->json(['status' =>'false','message' => 'Failed to create Report'], 200);
                }
            }
    }


    public function Report_Show(Request $request)
    {
            $this->validate($request,[
                'user_id'=>'required'
            ]);

            $user_id = $request->input('user_id');

            $reports = Report::where('user_id', $user_id)->get();

            if ($reports->isEmpty()) {
                return response()->json([
                    'status' => 'false',
                    'msg' => 'No Report found for the given User ID.',
                ], 200);
            } else {
                return response()->json([
                    'status' => 'true',
                    'msg' => 'All User Id base data',
                    'data' => $reports,
                ], 200);
            }
    }

    public function Report_Day(Request $request)
    {
            $this->validate($request, [
                'user_id' => 'required',
            ]);

            $user_id = $request->input('user_id');

            $today = date('Y-m-d'); // Get the current date in the 'Y-m-d' format

            $reports = Report::where('user_id', $user_id)
                ->whereDate('date', '=', $today) // Filter by today's date in 'Y-m-d' format
                ->latest('created_at')
                ->first();

            if (!$reports) {
                return response()->json([
                    'status' => 'false',
                    'msg' => 'No Report found for the given User ID today.',
                ], 200);
            } else {
                return response()->json([
                    'status' => 'true',
                    'msg' => 'Last Report data for the specified user_id',
                    'data' => $reports,
                ], 200);
            }
    }

    //Country list 
    public function Country_List()
    {
        $countries=Country::all();

        if($countries->isEmpty())
        {
            return response()->json([
                    'status' => 'false',
                    'msg' => 'No Country Found',
                ], 200);
        }
        else
        {
            return response()->json([
                    'status' => 'true',
                    'msg' => 'Country List',
                    'data' => $countries,
                ], 200);
        }

    }

    public function State_List($id)
    {
        $states=State::where('fk_country_master_id',$id)->get();

        if($states->isEmpty())
        {
            return response()->json([
                    'status' => 'false',
                    'msg' => 'No State Found',
                ], 200);
        }
        else
        {
            return response()->json([
                    'status' => 'true',
                    'msg' => 'State List',
                    'data' => $states,
                ], 200);
        }


    }

    public function District_List($id)
    {
        $district=District::where('fk_state_master_id',$id)->get();

        if($district->isEmpty())
        {
            return response()->json([
                    'status' => 'false',
                    'msg' => 'No District Found',
                ], 200);
        }
        else
        {
            return response()->json([
                    'status' => 'True',
                    'msg' => 'District List',
                    'data' => $district,
                ], 200);
        }
    }



    public function Order_Save(Request $request)
    {
        $this->validate($request,[
            'user_id'=>'required'
        ]);
        $params['user_id']=$request->user_id;
        $params['amount']=$request->amount;

        $order=Order::create($params);

        if($order)
        {
            foreach($request->items as $key=>$value)
            {
                $data['order_id']=$order->id;
                $data['item_id']=$value['id'];
                $data['name']=$value['name'];
                $data['price']=$value['price'];
                $data['qty']=$value['qty'];
                $data['unit']=$value['unit'];
                $data['subtotal']=$value['subtotal'];

                Order_history::create($data);
            }

        }

        if(!$order)
        {
            return response()->json(['status'=>'false','msg'=>'order Not Created'], 200);
        }
        else
        {
            return response()->json(['status'=>'true','msg'=>'Order Created Successfully'], 200);
        }

    }


            
    public function Order_Show(Request $request)
    {
        $this->validate($request, [
            'user_id' => 'required'
        ]);

        $user_id = $request->input('user_id');

        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $orders = Order::where('user_id', $user_id)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
        ->take($totalrecords)
        ->get();


        if ($orders->isEmpty()) 
        {
            return response()->json([
                'status' => 'false',
                'msg' => 'No Order found for the given User ID.',
            ], 200);
        }

        else 
        {
            $formattedorder = $orders->map(function ($order) {
                return [
                    'id' => $order->id,
                    'user_id' => $order->user_id,
                    'amount' => $order->amount,
                    'created_at' => Carbon::parse($order->created_at)->format('d-m-y'),
                ];
            });

            return response()->json([
                'status' => 'True',
                'msg' => 'Order found for the given User ID.',
                'data' => $formattedorder
            ], 200);

            
        }
    }


    public function Order_History_Show($order_id)
    {
        $order = Order::find($order_id);

        if (!$order) 
        {
            return response()->json(['status' => 'false', 'msg' => 'Order Not Found'], 404);
        }

        $orderDetails = [

            'user_id' => $order->user_id,
            'amount' => $order->amount,
            'created_at' => Carbon::parse($order->created_at)->format('Y-m-d'),
        ];

        $orderHistoryItems = Order_history::where('order_id', $order_id)
            ->select('item_id', 'name', 'price', 'qty','unit','subtotal')->orderby('id','desc')
            ->get();

        $items = [];
        foreach ($orderHistoryItems as $orderHistoryItem) 
        {
            $item = [
                'item_id' => $orderHistoryItem->item_id,
                'name' => $orderHistoryItem->name,
                'price' => $orderHistoryItem->price,
                'qty' => $orderHistoryItem->qty,
                'unit' => $orderHistoryItem->unit,
                'subtotal' => $orderHistoryItem->subtotal,
            ];
            $items[] = $item;
        }

        $orderDetails['items'] = $items;

        return response()->json([
            'status' => 'true',
            'msg' => 'List of Orders History',
            'data' => $orderDetails,
        ], 200);
    }


   public function FarmerOrderStore(Request $request)
   {

     // $validator = Validator::make($request->all(), 
     //    [
     //    'shop_id'=>'required',
     //    'farmer_code'=>'required',
     //    'amount'=>'required'
       
     //    ]);

     //    if ($validator->fails()) 
     //    {
     //        return response()->json([
     //            'error' => 'Validation failed',

     //            'message' => 'Fill All Fields'

     //        ], 422); // 422 Unprocessable Entity
     //    }


    $params['shop_id']=$request->shop_id;

    $params['farmer_code']=$request->farmer_code;

    $params['amount']= $request->amount;

    $farmerOrder=FarmerOrder::create($params);

    if(!$farmerOrder)
    {
        return response()->json(['status'=>'false','msg'=>'Farmer Order Not Created '],200);
    }

       return response()->json(['status'=>'True','msg'=>'Farmer Order Created Successfully'],200);

   }


   public function FarmerOrderView(Request $request)
   {


        $startfrom = $request->input('startfrom', 1); // Default to 1 if not provided

        $totalrecords = $request->input('totalrecords', 10); // Default to 10 if not provided

        $farmerOrders=FarmerOrder::where('shop_id',$request->shop_id)->orderby('id','desc')->skip(($startfrom - 1) * $totalrecords)
            ->take($totalrecords)
            ->get();

        if($farmerOrders->isEmpty())
        {
            return response()->json(['status'=>'false','msg'=>'Farmer Order Not Found '],200);
        }

        $formatteddata= $farmerOrders->map(function($farmer){

            return
            [
                'shop_id'=>$farmer->shop_id,
                'farmer_code'=>$farmer->farmer_code,
                'amount'=>$farmer->amount,
                'date'=> Carbon::parse($farmer->created_at)->format('d-m-Y')
            ];
        });

        return response()->json(['status'=>'True','msg'=>'Farmer Order List','date'=>$formatteddata],200);
    
   }

   public function SocialUrl()

   {

    $sociallinks=SocialLinks::whereNotNull('url')->get();

    if($sociallinks->isEmpty())
        {
            return response()->json(['status'=>'false','msg'=>'Url Not Found '],200);
        }
 
        return response()->json(['status'=>'True','msg'=>'Social links','date'=>$sociallinks],200);

   }


}




