<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">HeadQuaters</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="<?php echo e(url('headquater/create')); ?>">

                    <button type="button" class="btns primary-btn ml-4">

                        <span class="btn-icon-left" style="color: white">
                        + Add Headquater
                       </span>
                       

                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form method="GET" action="">

                            <div class="row text-right">

                                <div class="col-md-6"></div>

                                <div class="col-md-4">

                                    <input type="text" class="form-control right-search" name="search" value="<?php echo e($request->search); ?>" placeholder="Search by HeadQuater Name">

                                </div>

                                <div class="col-md-2">

                                    <label class="">&nbsp;</label>

                                    <button type="submit" class="btns primary-btn">Search</button>

                                </div>

                            </div>

                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    <?php if(!empty($head_quaters)): ?>

                                    <?php $__currentLoopData = $head_quaters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>

                                        <td><?php echo e(++$key); ?></td>


                                        <td><?php echo e($value->name); ?></td>

                                        <td class="text-right">

                                        <a href="<?php echo e(route('headquater.edit',encrypt($value->id))); ?>">
                                        <button type="button" class="btns success-btn btn-sm" title="Edit" alt="Edit"><i class="fas fa-edit"></i> 
                                        </button>
                                         </a>


                                        <a href="<?php echo e(route('headquater.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')">
                                        <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                        </button>
                                        </a>

                                            </td>

                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php if($head_quaters->count() == 0): ?>

                                        <tr class="text-center">

                                            <td colspan="6">No headquater to display.</td>

                                        </tr>

                                        <?php endif; ?>

                                    <?php endif; ?>

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying <?php echo e($head_quaters->count()); ?> of <?php echo e($head_quaters->total()); ?>headquaters.</p>

                        </div>

                         <div class="pagination">
                            <ul class="pagination-list">
                                <?php if($head_quaters->currentPage() > 1): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($head_quaters->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                    </li>
                                <?php endif; ?>

                                <?php if($head_quaters->currentPage() > 3): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($head_quaters->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                    </li>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                <?php endif; ?>

                                <?php $__currentLoopData = range(max(1, $head_quaters->currentPage() - 2), min($head_quaters->lastPage(), $head_quaters->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="pagination-item <?php echo e($page == $head_quaters->currentPage() ? 'active' : ''); ?>">
                                        <a href="<?php echo e($head_quaters->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if($head_quaters->currentPage() < $head_quaters->lastPage() - 2): ?>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($head_quaters->appends(request()->all())->url($head_quaters->lastPage())); ?>" class="pagination-link"><?php echo e($head_quaters->lastPage()); ?></a>
                                    </li>
                                <?php endif; ?>

                                <?php if($head_quaters->hasMorePages()): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($head_quaters->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/Company/resources/views/headquater/index.blade.php ENDPATH**/ ?>