<?php $__env->startSection('main-container'); ?>

<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>TA & DA</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="<?php echo e(route('/')); ?>" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="<?php echo e(route('user_by_search_ta_da.search')); ?>" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="user_id" type="button" data-toggle="dropdown">
                                    <option value="">Select User</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" <?php echo e($user->id == $request->user_id ? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btns primary-btn" value="Filter">
                            </div>
                        </div>
                    </form>


                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>DESTINATION</th>

                                    <th>DATE</th>

                                    <th>DEPARTED</th>

                                    <th>ARRIVAL</th>

                                    <th>STATUS</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                <?php if(!empty($booking_travel)): ?>

                                <?php $__currentLoopData = $booking_travel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td><?php echo e(++$key); ?></td>

                                    <td><?php echo e($value->User->name ?? 'N/A'); ?></td>

                                    <td><?php echo e($value->destination); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($value->created_at)->format('d-m-Y')); ?></td>

                                    <td><?php echo e($value->depart_town); ?></td>

                                    <td><?php echo e($value->arrival_town); ?></td>

                                    <td>
                                        <?php if($value->status=='1'): ?>
                                            <a href="<?php echo e(url('bookingactive/'.$value->id)); ?>" onclick="return confirmAction('disapproved');">
                                                <button class="btns success-btn">Approved</button>
                                            </a>
                                        <?php else: ?>
                                            <a href="<?php echo e(url('bookingactive/'.$value->id)); ?>" onclick="return confirmAction('approved');">
                                                <button class="btn btn-danger">Disapproved</button>
                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <script>
                                    function confirmAction(action) {
                                        return confirm(`Are you sure you want to ${action} this?`);
                                    }
                                    </script>

                                     <td class="text-right">

                                        <a href="<?php echo e(route('ta_da.view', encrypt($value->id))); ?>">
                                        <button type="button" class="btns success-btn btn-sm" title="View More" alt="View More"><i class="fas fa-eye"></i>
                                        </button>
                                    </a>

                                         <a href="<?php echo e(route('ta_da.delete', encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')">
                                        <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                        </button>
                                    </a>



                                    </td>

                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($booking_travel->count() == 0): ?>

                                    <tr class="text-center">

                                        <td colspan="6">No Booking Travel to display.</td>

                                    </tr>

                                    <?php endif; ?>

                                <?php endif; ?>

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Destination</th>

                                    <th>Date</th>

                                    <th>Departed</th>

                                    <th>Arrival</th>

                                    <th>Status</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying <?php echo e($booking_travel->count()); ?> of <?php echo e($booking_travel->total()); ?> Add Booking Travel.</p>

                    </div>




                    <div class="pagination">
                        <ul class="pagination-list">
                            <?php if($booking_travel->currentPage() > 1): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($booking_travel->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                </li>
                            <?php endif; ?>

                            <?php if($booking_travel->currentPage() > 3): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($booking_travel->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = range(max(1, $booking_travel->currentPage() - 2), min($booking_travel->lastPage(), $booking_travel->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="pagination-item <?php echo e($page == $booking_travel->currentPage() ? 'active' : ''); ?>">
                                    <a href="<?php echo e($booking_travel->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($booking_travel->currentPage() < $booking_travel->lastPage() - 2): ?>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="<?php echo e($booking_travel->appends(request()->all())->url($booking_travel->lastPage())); ?>" class="pagination-link"><?php echo e($booking_travel->lastPage()); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($booking_travel->hasMorePages()): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($booking_travel->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/Company/resources/views/ta_da/index.blade.php ENDPATH**/ ?>