<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Leave</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="<?php echo e(route('/')); ?>" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="<?php echo e(route('leave_date.date')); ?>" method="get">
                        <div class="row">
                           <div class="col-md-5 form-group">
                               <label for="">Date From</label>
                               <input type="date" name="date_from" class="form-control" value="<?php echo e($request->date_from); ?>">
                            </div>
                            <div class="col-md-5 form-group">
                               <label for="">Date From</label>
                               <input type="date" name="date_to" class="form-control" value="<?php echo e($request->date_to); ?>">
                            </div>
                            <div class="col-md-2 form-group" style="margin-top:30px;">
                               <input type="submit" class="btns primary-btn" value="Search">
                            </div>
                        </div>
                   </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>START DATE</th>

                                    <th>END DATE</th>

                                    <th>LEAVE MSG</th>

                                    <th>DATE</th>

                                    <th>STATUS</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                <?php if(!empty($leaves)): ?>

                                <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td><?php echo e(++$key); ?></td>

                                    <td><?php echo e($value->User->name ?? 'N/A'); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($value->start_date)->format('d-m-Y')); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($value->end_date)->format('d-m-Y')); ?></td>

                                    <td><?php echo e($value->leave_msg); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($value->created_at)->format('d-m-Y')); ?></td>

                                    <td>
                                        <?php if($value->status=='1'): ?>
                                            <a href="<?php echo e(url('leaveactive/'.$value->id)); ?>" onclick="return confirmAction('Disapproved');">
                                                <button class="btns success-btn">Approved</button>
                                            </a>
                                        <?php else: ?>
                                            <a href="<?php echo e(url('leaveactive/'.$value->id)); ?>" onclick="return confirmAction('Approved');">
                                                <button class="btn btn-danger">Disapproved</button>
                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <script>
                                    function confirmAction(action) {
                                        return confirm(`Are you sure you want to ${action} this?`);
                                    }
                                    </script>


                                     <td class="text-right">


                                         <a href="<?php echo e(route('leave.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')">
                                        <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                        </button>
                                        </a>

                                    </td>

                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($leaves->count() == 0): ?>

                                    <tr class="text-center">

                                        <td colspan="6">No leaves to display.</td>

                                    </tr>

                                    <?php endif; ?>

                                <?php endif; ?>

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Start Date</th>

                                    <th>End Date</th>

                                    <th>Leave Msg</th>

                                    <th>Date</th>

                                    <th>Status</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying <?php echo e($leaves->count()); ?> of <?php echo e($leaves->total()); ?> Add Booking Travel.</p>

                    </div>




                    <div class="pagination">
                        <ul class="pagination-list">
                            <?php if($leaves->currentPage() > 1): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($leaves->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                </li>
                            <?php endif; ?>

                            <?php if($leaves->currentPage() > 3): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($leaves->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = range(max(1, $leaves->currentPage() - 2), min($leaves->lastPage(), $leaves->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="pagination-item <?php echo e($page == $leaves->currentPage() ? 'active' : ''); ?>">
                                    <a href="<?php echo e($leaves->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($leaves->currentPage() < $leaves->lastPage() - 2): ?>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="<?php echo e($leaves->appends(request()->all())->url($leaves->lastPage())); ?>" class="pagination-link"><?php echo e($leaves->lastPage()); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($leaves->hasMorePages()): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($leaves->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 <?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/DATA/resources/views/leave/index.blade.php ENDPATH**/ ?>