<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\{RoleController,AdminController,CompanyServiceController,UserController,CompanyController,LocationController,ReportController,UsersController,GamesController,GamesQuestionController,AttributeController,GamesResultController};
use App\Models\{Country,City,State,Company,Invoice,Currency,AllCurrency,Lead,Source,User,GroupUsers,Group,ServiceInvoice};
use App\Http\Middleware\Authenticate;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/forgetpassword',[CompanyServiceController::class,'ShowForgetPasswordForm'])->name('forget.password.get');

Route::post('forgetpassword',[CompanyServiceController::class,'SubmitForgetPasswordForm'])->name('forget.password.post');

Route::get('/resetpassword/{token}',[CompanyServiceController::class,'ShowResetPasswordForm'])->name('reset.password.get');

Route::post('resetpassword',[CompanyServiceController::class,'SubmitResetPasswordForm'])->name('reset.password.post');

Route::group(['middleware'=>['auth']],function(){
    Route::get('/index',[AdminController::class,'Dashboard']);

});

Route::get('/', function () {
    if(Auth::check())
    {
        if(Auth::check() && Auth::user()->role=='Admin'){
            return redirect('/index');
        } else {
            Auth::logout();
            Session::flush();
            return redirect()->back()->with('error','Try Again');;
        }
        
    }
    else
    {
        return view('frontend.pages-login');
    }
})->name('/');

Route::post('/signed',[AdminController::class,'signIn'])->name('signed');



Route::group(['middleware' => ['auth']], function() {
   /**
   * Logout Route
   */
   Route::post('/logout',[LoginController::class,'logout']);

});

Route::group(['middleware'=>['auth']],function(){

Route::resource('admin',AdminController::class);



Route::controller(UsersController::class)->group(function () {

        Route::get('users', 'index')->name('users');

        Route::get('user/create', 'create')->name('user.create');

        Route::post('user/store', 'store')->name('user.store');

        Route::get('user/edit/{id}', 'edit')->name('user.edit');

        Route::post('user/update/{id}', 'update')->name('user.update');

        Route::get('user/view/{id}', 'show')->name('user.view');

        Route::get('user/delete/{id}', 'destroy')->name('user.delete');

    });

    
Route::controller(GamesController::class)->group(function () {

        Route::get('games', 'index')->name('games');

        Route::get('game/create', 'create')->name('game.create');

        Route::post('game/store', 'store')->name('game.store');

        Route::get('game/edit/{id}', 'edit')->name('game.edit');

        Route::post('game/update/{id}', 'update')->name('game.update');

        Route::get('game/view/{id}', 'show')->name('game.view');

        Route::get('gameactive/{id}', 'game_active')->name('gameactive');

        Route::get('game/delete/{id}', 'destroy')->name('game.delete');

        Route::get('add_questions/{id}', 'show_question')->name('add_questions');

        Route::get('add_attributes/{id}', 'show_attribute')->name('add_attributes');

        

    });



Route::controller(GamesQuestionController::class)->group(function () {

        Route::get('games_questions', 'index')->name('games_questions');

        Route::post('games_question/store', 'store')->name('games_question.store');

        Route::post('games_question/update/{id}', 'update')->name('games_question.update');

        Route::get('games_question/delete/{id}', 'destroy')->name('games_question.delete');

    });

Route::controller(AttributeController::class)->group(function () {

        Route::get('games_attribute', 'index')->name('games_questions');

        Route::post('games_attribute/store', 'store')->name('games_attribute.store');

        Route::post('games_attribute/update/{id}', 'update')->name('games_attribute.update');

        Route::get('games_attribute/delete/{id}', 'destroy')->name('games_attribute.delete');

    });

Route::controller(GamesResultController::class)->group(function () {

        Route::get('games_results', 'index')->name('games_results');

        Route::get('show_lists_players/{id}', 'show_players_lists')->name('show.lists.players');

        Route::get('show_winners_players/{id}', 'show_winners_lists')->name('show.winners');

        Route::get('winners/{id}', 'game_winners')->name('winnersactive');

    });






Route::controller(LocationController::class)->group(function () {

        Route::get('terms_conditions', 'index')->name('terms_conditions');

        Route::get('terms_condition/create', 'create')->name('terms_condition.create');

        Route::get('terms_condition/edit/{id}', 'edit')->name('terms_condition.edit');

        Route::post('terms_condition/update/{id}', 'update')->name('terms_condition.update');

    });



Route::resource('role',RoleController::class);

Route::get('/addroles',[RoleController::class,'index'])->name('addroles');

Route::post('/role-submit',[RoleController::class,'submitRole']);

Route::get('/permissions/{id}',[RoleController::class,'show_permission']);

Route::post('/role-edit/{id}',[RoleController::class,'roleEdit']);

Route::get('/deleterole/{id}',[RoleController::class,'delete_Role']);

Route::get('onchangerole/{id}',[RoleController::class,'ChangeRole']);

Route::get('permis',function(){
    $role=Session::get('roles');
    $roles=Role::get();
    $permissions=Permission::get();
    $rolePermissions = $role->permissions->pluck('id')->toArray();

    $role_permission = Permission::get();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, "."));

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }

        }

    return view('frontend.permis',compact('role','roles','permissions','rolePermissions','custom_permission'));
});

// Users

Route::get('/users-profile',[AdminController::class,'UserProfile'])->name('users-profile');

Route::post('/update/profile',[AdminController::class,'update_profile'])->name('update.profile');

Route::POST('/login-with-user/{id}',[UserController::class,'UserLogin'])->name('login-with-user');



Route::view('components-view',"frontend.components-view");

Route::get('currency-page',[AdminController::class,'Currencyfun']);
Route::post('storecurrency',[AdminController::class,'SetCurrency']);
Route::post('/addnewcurrency',[AdminController::class,'AddCurrency']);
Route::get('/deletecurrency/{id}',[AdminController::class,'deleteCurrency']);

Auth::routes();


});


