<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Login
Route::post('/game', [App\Http\Controllers\API\ApiController::class,'Game_get']);

//Aatribute Get
Route::post('/games_id/attribute', [App\Http\Controllers\API\ApiController::class,'Get_Attribute']);

//Question Get
Route::post('/games_id/questions', [App\Http\Controllers\API\ApiController::class,'Get_Questions']);

//Store Game Play Details
Route::post('/play_games/store', [App\Http\Controllers\API\ApiController::class,'Play_Games_Store']);

//Store Game Play Details
Route::post('/play_games/result/update', [App\Http\Controllers\API\ApiController::class,'Play_Games_Result_Update']);

//Result Get
Route::post('/games_id/result', [App\Http\Controllers\API\ApiController::class,'Get_Results']);

Route::post('/games/result/count', [App\Http\Controllers\API\ApiController::class,'Games_Result_Count']);

Route::get('/terms_candition', [App\Http\Controllers\API\ApiController::class,'Terms_Conditions']);













