@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Add New User</h4>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('users')}}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>

</div>



<div class="content-wrapper mt-4">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('user.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Name" required>
                                  <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Mobile<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="mobile" value="{{old('mobile')}}" placeholder="Enter Mobile No" required>
                                    <span class="text-danger"> @error('mobile'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{old('email')}}" placeholder="Enter Email Id" required>
                                    <span class="text-danger"> @error('email'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Password<span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" value="{{old('password')}}" placeholder="Enter password Id" required>
                                    <span class="text-danger"> @error('password'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                     <select class=" form-control dropdown-toggle" name="role" type="button" data-toggle="dropdown">
                                        <option value="">Select Role</option>
                                        @foreach($role as $rol)
                                          <option value="{{ $rol->name }}">{{str_replace('_','',str_replace(Auth::user()->company_id,'',$rol->name))}}</option>
                                          @endforeach
                                      </select>
                                    <span class="text-danger">@error('role'){{ $message }}@enderror</span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>DOB</label>
                                    <input type="date" class="form-control" name="dob" value="{{old('dob')}}" placeholder="Enter date of birth">
                                    <span class="text-danger"> @error('dob'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="state">State</label>
                                    <select class="form-control" id="state-dropdown" name="state">
                                        <option value="">Select State</option>
                                        @foreach ($states as $state)
                                            <option value="{{$state->id}}">{{$state->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="city">City</label>
                                    <select class="form-control" id="city-dropdown" name="city">
                                        <option value="">Select City</option>
                                    </select>
                                </div>


                                <div class="form-group col-lg-6">
                                    <label>Pincode</label>
                                    <input type="number" class="form-control" name="pincode" value="{{old('pincode')}}" placeholder="Enter Pincode">
                                    <span class="text-danger"> @error('pincode'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">

                                    <label>Address </label>

                                    <textarea class="form-control" name="address" placeholder="Enter Address"></textarea>

                                    <span class="text-danger"> @error('address'){{ $message }}@enderror </span>

                                </div>

                                <div class="form-group col-lg-12">

                                    <label>Bank Details </label>

                                    <textarea class="form-control ckeditor" name="bank_details" placeholder="Enter Bank Details"></textarea>

                                    <span class="text-danger"> @error('bank_details'){{ $message }}@enderror </span>

                                </div>


                                <div class="text-center">
                                    <button type="submit" class="btns primary-btn btn-sm">Submit</button>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

    

</div>

</main><!-- End #main -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>

<script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>
 @endsection

 <script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>



